#include <systemc>
#include <sys/time.h>
#include <iostream>
#include <cstdlib>
#include <cstdarg>

#include "mapping_table.h"
#include "dspin_simple_ring_fast_c.h"
#include "soclib_vci_initiator.h"
#include "soclib_vci_target.h"
#include "alloc_elems.h"
#include "vci_param.h"

#define SRCID_WIDTH     4
#define CYCLES 100000

int _main(int argc, char *argv[])
{
	using namespace sc_core;
	// Avoid repeating these everywhere
	using soclib::common::IntTab;
	using soclib::common::Segment;
        using soclib::common::alloc_elems;

	// Define VCI parameters
	typedef soclib::caba::VciParams<4,8,32,1,1,1,8,4,4,1> vci_param;

       // Mapping table primary network

        soclib::common::MappingTable maptabp(32, IntTab(SRCID_WIDTH), IntTab(SRCID_WIDTH), 0x00FF0000);

       for ( size_t p = 0 ; p < 4 ; p++) 
       {
       	std::ostringstream sp;
       	sp << "c_seg_proc_" <<  p;
       	maptabp.add( Segment( sp.str() , (p << (32 - SRCID_WIDTH)), 0x10 , IntTab(p) , false)); 
       }
	// Signals

	sc_clock	signal_clk("clk");
	sc_signal<bool> signal_resetn("resetn");

	soclib::caba::DspinSignals<40> * dspin_cmd = soclib::common::alloc_elems<soclib::caba::DspinSignals<40> >("dspin_cmd", 5);
	soclib::caba::DspinSignals<33> * dspin_rsp = soclib::common::alloc_elems<soclib::caba::DspinSignals<33> >("dspin_rsp", 5);


	soclib::caba::SoclibVciInitiator<40,33> 
	initp0("initp0", 4);
	//soclib::caba::SoclibVciInitiator<vci_param> 
	//initp1("initp1", 1); 
	//soclib::caba::SoclibVciInitiator<vci_param> 
	//initp2("initp2", 2);
	//soclib::caba::SoclibVciInitiator<vci_param> 
	//initp3("initp3", 3);

	soclib::caba::SoclibVciTarget<40,33> 
	target0("target0"); 
	soclib::caba::SoclibVciTarget<40,33> 
	target1("target1");
	soclib::caba::SoclibVciTarget<40,33> 
	target2("target2");
	soclib::caba::SoclibVciTarget<40,33> 
	target3("target3");

	// Local ring interconnects : 1 direct ring per cluster
	soclib::caba::DspinSimpleRingFastC<vci_param, 40, 33> 
        cluster("cluster",maptabp, IntTab(), 2, 1, 4);
	

	// Initiators
	initp0.p_clk(signal_clk);  
	initp0.p_resetn(signal_resetn);  
	initp0.p_cmd_out(dspin_cmd[0]);
	initp0.p_rsp_in(dspin_rsp[0]);


       // Target
	target0.p_clk(signal_clk);
	target0.p_resetn(signal_resetn);
	target0.p_cmd_in(dspin_cmd[1]);
	target0.p_rsp_out(dspin_rsp[1]);

	target1.p_clk(signal_clk);
	target1.p_resetn(signal_resetn);
	target1.p_cmd_in(dspin_cmd[2]);
	target1.p_rsp_out(dspin_rsp[2]);

	target2.p_clk(signal_clk);
	target2.p_resetn(signal_resetn);
	target2.p_cmd_in(dspin_cmd[3]);
	target2.p_rsp_out(dspin_rsp[3]);

	target3.p_clk(signal_clk);
	target3.p_resetn(signal_resetn);
	target3.p_cmd_in(dspin_cmd[4]);
	target3.p_rsp_out(dspin_rsp[4]);

  	cluster.p_clk(signal_clk);
	cluster.p_resetn(signal_resetn);

        cluster.p_cmd_out[0](dspin_cmd[1]);
	cluster.p_rsp_in[0](dspin_rsp[1]);
        cluster.p_cmd_out[1](dspin_cmd[2]);
	cluster.p_rsp_in[1](dspin_rsp[2]);
        cluster.p_cmd_out[2](dspin_cmd[3]);
	cluster.p_rsp_in[2](dspin_rsp[3]);
        cluster.p_cmd_out[3](dspin_cmd[4]);
	cluster.p_rsp_in[3](dspin_rsp[4]);

        cluster.p_cmd_in[0](dspin_cmd[0]);
	cluster.p_rsp_out[0](dspin_rsp[0]);


////////////////////////////////////////////////////////

	int ncycles;

	sc_start(sc_core::sc_time(0, SC_NS));
	signal_resetn = false;

	sc_start(sc_core::sc_time(1, SC_NS));
	signal_resetn = true;

	while(1)
	{
	  sc_start(sc_core::sc_time(CYCLES, SC_NS));

        }

        std::cout << "Hit ENTER to end simulation" << std::endl;
        char buf[1];

	std::cin.getline(buf,1);

	return EXIT_SUCCESS;
}

int sc_main (int argc, char *argv[])
{
	try {
		return _main(argc, argv);
	} catch (std::exception &e) {
		std::cout << e.what() << std::endl;
	} catch (...) {
		std::cout << "Unknown exception occured" << std::endl;
		throw;
	}
	return 1;
}
