//////////////////////////////////////////////////////////////////////////////
// File: simple_cluster.h
// Author: Alain Greiner 
// Copyright: UPMC/LIP6
// Date : march 2013
// This program is released under the GNU public license
//////////////////////////////////////////////////////////////////////////////

#ifndef TSARV5_SIMPLE_CLUSTER_H
#define TSARV5_SIMPLE_CLUSTER_H

#include <systemc>
#include <sys/time.h>
#include <iostream>
#include <sstream>
#include <cstdlib>
#include <cstdarg>

#include "dspin_packet_generator.h"
#include "dspin_local_crossbar.h"
#include "vci_dspin_initiator_wrapper.h"
#include "vci_dspin_target_wrapper.h"
#include "virtual_dspin_router.h"
#include "vci_synthetic_target.h"
#include "vci_synthetic_initiator.h"

namespace soclib { namespace caba	{

///////////////////////////////////////////////////////////////////////////
template<typename vci_param, int cmd_width, int rsp_width>
class SimpleCluster 
///////////////////////////////////////////////////////////////////////////
    : public soclib::caba::BaseModule
{

  public:

	// Ports
    sc_in<bool>                             		p_clk;
    sc_in<bool>                             		p_resetn;
	soclib::caba::DspinOutput<cmd_width>   			**p_cmd_out;
	soclib::caba::DspinInput<cmd_width>    			**p_cmd_in;
    soclib::caba::DspinOutput<rsp_width>           	**p_rsp_out;
    soclib::caba::DspinInput<rsp_width>            	**p_rsp_in;

	// DSPIN signals between DSPIN routers and local_crossbars
	DspinSignals<cmd_width> 	                    signal_dspin_cmd_l2g_d; 
	DspinSignals<cmd_width> 	                    signal_dspin_cmd_g2l_d; 
	DspinSignals<cmd_width> 	                    signal_dspin_cmd_l2g_c;
	DspinSignals<cmd_width> 	                    signal_dspin_cmd_g2l_c; 
	DspinSignals<rsp_width> 	                    signal_dspin_rsp_l2g_d; 
	DspinSignals<rsp_width> 	                    signal_dspin_rsp_g2l_d; 
	DspinSignals<rsp_width> 	                    signal_dspin_rsp_l2g_c;
	DspinSignals<rsp_width> 	                    signal_dspin_rsp_g2l_c;

	// signals between VCI components and VCI/DSPIN wrappers
	VciSignals<vci_param> 		                    signal_vci_ini; 
	VciSignals<vci_param> 		                    signal_vci_tgt; 

	// DSPIN signals between DSPIN component and local crossbars
	DspinSignals<cmd_width>                         signal_dspin_ini_cmd_d;
	DspinSignals<cmd_width>                         signal_dspin_tgt_cmd_d;
	DspinSignals<rsp_width>                         signal_dspin_ini_rsp_d;
	DspinSignals<rsp_width>                         signal_dspin_tgt_rsp_d;

	DspinSignals<cmd_width>                         signal_dspin_ini_cmd_c;
	DspinSignals<cmd_width>                         signal_dspin_tgt_cmd_c;
	DspinSignals<rsp_width>                         signal_dspin_ini_rsp_c;
	DspinSignals<rsp_width>                         signal_dspin_tgt_rsp_c;

    // pointers on hardware components

    VciSyntheticInitiator<vci_param>*                 	        ini_d;
    VciSyntheticTarget<vci_param>*                              tgt_d;
    VciDspinInitiatorWrapper<vci_param,cmd_width,rsp_width>*    w_ini_d;
    VciDspinTargetWrapper<vci_param,cmd_width,rsp_width>*       w_tgt_d;
    DspinPacketGenerator<cmd_width,rsp_width>*                  ini_c;
    DspinPacketGenerator<rsp_width,cmd_width>*                  tgt_c;

    DspinLocalCrossbar<cmd_width>*                              xbar_cmd_d;
    DspinLocalCrossbar<rsp_width>*                              xbar_rsp_d;
    DspinLocalCrossbar<cmd_width>*                              xbar_cmd_c;
    DspinLocalCrossbar<rsp_width>*                              xbar_rsp_c;

    VirtualDspinRouter<cmd_width>*	                        	router_cmd;
    VirtualDspinRouter<rsp_width>*                              router_rsp;

    // constructor

	SimpleCluster(sc_module_name  name,
                  size_t          x,           // x coordinate
                  size_t          y,           // y coordinate
                  size_t          x_width,     // x field number of bits
                  size_t          y_width,     // y field number of bits
                  size_t          load_d,      // load (* 1000) on direct network
                  size_t          plen_d,      // packet length on direct network
                  size_t          load_ini_c,  // load (* 1000) on cc network 40
                  size_t          plen_ini_c,  // packet length on cc network 40
                  size_t          load_tgt_c,  // load (* 1000) on cc network 33
                  size_t          plen_tgt_c,  // packet length on cc network 33
                  size_t          bcp_ini,     // broadcast period on cc network 40
                  size_t          bcp_tgt );   // broadcast period on cc network 33

};

}}	// end namespaces

#endif
