//////////////////////////////////////////////////////////////////////////////
// File: tsar_cluster_mmu.h
// Author: Alain Greiner 
// Copyright: UPMC/LIP6
// Date : march 2011
// This program is released under the GNU public license
//////////////////////////////////////////////////////////////////////////////

#ifndef SOCLIB_CABA_TSAR_CLUSTER_MMU_H
#define SOCLIB_CABA_TSAR_CLUSTER_MMU_H

#include <systemc>
#include <sys/time.h>
#include <iostream>
#include <sstream>
#include <cstdlib>
#include <cstdarg>

#include "gdbserver.h"
#include "mapping_table.h"
#include "mips32.h"
#include "vci_simple_ram.h"
#include "vci_xicu.h"
#include "vci_local_crossbar.h"
#include "virtual_dspin_router.h"
#include "vci_vdspin_target_wrapper.h"
#include "vci_vdspin_initiator_wrapper.h"
#include "vci_multi_tty.h"
#include "vci_multi_nic.h"
#include "vci_block_device_tsar_v4.h"
#include "vci_framebuffer.h"
#include "vci_multi_dma.h"
#include "vci_mem_cache.h"
#include "vci_cc_vcache_wrapper.h"

namespace soclib {
namespace caba	{

///////////////////////////////////////////////////////////////////////////
template<typename vci_param, typename iss_t, int cmd_width, int rsp_width>
class TsarClusterMmu 
///////////////////////////////////////////////////////////////////////////
    : public soclib::caba::BaseModule
{

  public:

	// Ports
    sc_in<bool>                             		p_clk;
    sc_in<bool>                             		p_resetn;
	soclib::caba::DspinOutput<cmd_width>   			**p_cmd_out;
	soclib::caba::DspinInput<cmd_width>    			**p_cmd_in;
    soclib::caba::DspinOutput<rsp_width>           	**p_rsp_out;
    soclib::caba::DspinInput<rsp_width>            	**p_rsp_in;

    // interrupt signals
	sc_signal<bool>     	signal_false;
	sc_signal<bool> 		signal_proc_it[8];
	sc_signal<bool> 		signal_irq_mdma[8];
	sc_signal<bool>			signal_irq_mtty[23];
	sc_signal<bool> 		signal_irq_mnic_rx[8];	// unused
	sc_signal<bool> 		signal_irq_mnic_tx[8];	// unused
	sc_signal<bool> 		signal_irq_bdev;
	
	// DSPIN signals between DSPIN routers and VCI/DSPIN wrappers
	DspinSignals<cmd_width> 	signal_dspin_cmd_l2g_d; 
	DspinSignals<cmd_width> 	signal_dspin_cmd_g2l_d; 
	DspinSignals<cmd_width> 	signal_dspin_cmd_l2g_c;
	DspinSignals<cmd_width> 	signal_dspin_cmd_g2l_c; 
	DspinSignals<rsp_width> 	signal_dspin_rsp_l2g_d; 
	DspinSignals<rsp_width> 	signal_dspin_rsp_g2l_d; 
	DspinSignals<rsp_width> 	signal_dspin_rsp_l2g_c;
	DspinSignals<rsp_width> 	signal_dspin_rsp_g2l_c;

	// VCI signals between VCI/DSPIN wrappers and local crossbars
	VciSignals<vci_param>  		signal_vci_l2g_d; 
	VciSignals<vci_param>  		signal_vci_g2l_d; 
	VciSignals<vci_param>  		signal_vci_l2g_c; 
	VciSignals<vci_param>  		signal_vci_g2l_c; 

	// Direct VCI signals
	VciSignals<vci_param> 		signal_vci_ini_d_proc[4]; 
	VciSignals<vci_param>  		signal_vci_ini_d_bdev; 
	VciSignals<vci_param>  		signal_vci_ini_d_mdma; 

	VciSignals<vci_param>		signal_vci_tgt_d_memc;
	VciSignals<vci_param> 		signal_vci_tgt_d_mtty;
	VciSignals<vci_param> 		signal_vci_tgt_d_xicu;
	VciSignals<vci_param> 		signal_vci_tgt_d_bdev;
	VciSignals<vci_param> 		signal_vci_tgt_d_mdma;
	VciSignals<vci_param> 		signal_vci_tgt_d_brom;
	VciSignals<vci_param> 		signal_vci_tgt_d_fbuf;
	VciSignals<vci_param> 		signal_vci_tgt_d_mnic;

	// Coherence VCi signals
	VciSignals<vci_param> 		signal_vci_ini_c_proc[4];
	VciSignals<vci_param> 		signal_vci_tgt_c_proc[4];
	VciSignals<vci_param> 		signal_vci_ini_c_memc;
	VciSignals<vci_param> 		signal_vci_tgt_c_memc;

	// external RAM VCI signal
	VciSignals<vci_param> 		signal_vci_xram;
	
    // Components

    VciCcVCacheWrapper<vci_param, iss_t>*                 	proc[8];
    VciMemCache<vci_param>*                               	memc;
    VciXicu<vci_param>*                                     	xicu;
    VciLocalCrossbar<vci_param>*                                xbard;
    VciLocalCrossbar<vci_param>*                                xbarc;
    VciVdspinTargetWrapper<vci_param,cmd_width,rsp_width>*      tgtwrapperd;
    VciVdspinInitiatorWrapper<vci_param,cmd_width,rsp_width>*   iniwrapperd;
    VciVdspinTargetWrapper<vci_param,cmd_width,rsp_width>*      tgtwrapperc;
    VciVdspinInitiatorWrapper<vci_param,cmd_width,rsp_width>*   iniwrapperc;
    VirtualDspinRouter<cmd_width>*                              cmdrouter;
    VirtualDspinRouter<rsp_width>*	                        	rsprouter;
    VciSimpleRam<vci_param>*                                    brom;
    VciMultiTty<vci_param>*                                     mtty;
    VciFrameBuffer<vci_param>*                                  fbuf;
    VciMultiNic<vci_param>*                                     mnic;
    VciBlockDeviceTsarV4<vci_param>*                            bdev;
    VciMultiDma<vci_param>*                                     mdma;
    VciSimpleRam<vci_param>*                                    xram;

	TsarClusterMmu(sc_module_name                     insname,
                     size_t                             nb_procs,      // number of processors 
                     size_t                             nb_ttys,       // number of TTY terminals 
                     size_t                             nb_dmas,       // number of DMA channels 
                     size_t                             x,             // x coordinate
                     size_t                             y,             // y coordinate
                     size_t                             cluster,       // y + ymax*x
                     const soclib::common::MappingTable &mtd,          // direct mapping table
                     const soclib::common::MappingTable &mtc,          // coherence mapping table
                     const soclib::common::MappingTable &mtx,          // xram mapping table
                     size_t	                            x_width,       // x field number of bits
                     size_t	                            y_width,       // y field number of bits
                     size_t	                            tgtid_memc,
                     size_t	                            tgtid_xicu,
                     size_t                             tgtid_mdma,
                     size_t	                            tgtid_fbuf,
                     size_t                             tgtid_mtty,
                     size_t                             tgtid_brom,
                     size_t                             tgtid_mnic,
                     size_t                             tgtid_bdev,
                     size_t                             memc_ways,
                     size_t                             memc_sets,
                     size_t                             l1_i_ways,
                     size_t                             l1_i_sets, 
                     size_t                             l1_d_ways,
                     size_t                             l1_d_sets,	
                     size_t                             xram_latency,  // external ram latency
                     bool                               io,	           // I/O cluster if true
                     size_t                             xfb,           // frame buffer pixels
                     size_t                             yfb,           // frame buffer lines
                     char*                              disk_name,     // virtual disk name for BDEV
                     size_t                             block_size,    // block size for BDEV
                     size_t                             nic_channels,  // number of channels
                     char*                              nic_rx_name,   // file name rx packets
                     char*                              nic_tx_name,   // file name tx packets
                     uint32_t							nic_timeout,   // number of cycles
			         const Loader                       &loader,       // loader for BROM
                     uint32_t                           frozen_cycles, // max frozen cycles
                     uint32_t                           start_debug_cycle,
                     bool                               memc_debug_ok, 
                     bool                               proc_debug_ok); 

	~TsarClusterMmu();
};
}}

#endif
