 /* SOCLIB_LGPL_HEADER_BEGIN
 * 
 * This file is part of SoCLib, GNU LGPLv2.1.
 * 
 * SoCLib is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; version 2.1 of the License.
 * 
 * SoCLib is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with SoCLib; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 * 
 * SOCLIB_LGPL_HEADER_END
 *
 * Author   : Abdelmalek SI MERABET 
 * Date     : February 2013
 * Copyright: UPMC - LIP6
 */
/////////////////////////////////////////////////////////////////////////////
//   Ring : Broadcast-inval : 2 flits l2(1)->l1(n)                         //
//---------------------------------------------------------------------------
//  1st flit    | eop |xmin  |xmax  |ymin  |ymax  |  memcid       | lid*  |1|
//     (40)       (1)   (5)    (5)    (5)    (5)     (14)            (4)  (1)
//---------------------------------------------------------------------------
//  next flit   | eop |res| trdid |     nline                                |
//     (40)       (1)  (1)   (4)        (34)                                         
//---------------------------------------------------------------------------
// *lid : local id (port number on ring) for sequential broadcast
//////////////////////////////////////////////////////////////////////////////
//   Ring : Multicast-inval  2 flits (l2->l1)                               //
//----------------------------------------------------------------------------
//  1st flit    | eop | procid          |res| memcid        | trdid | type |0|
//     (40)       (1)   (14)             (3)  (14)            (4)      (3) (1)
//----------------------------------------------------------------------------
//  next flit   | eop |res   |                nline                          |
//    (40)        (1)  (5)                     (34)                                  
//////////////////////////////////////////////////////////////////////////////
//   Ring : Multicast-update  2+N flits l2(1)->l1(n)                        //
//----------------------------------------------------------------------------
//  1st flit    | eop | procid          |res| memcid        | trdid | type |0|
//     (40)       (1)   (14)             (3)  (14)            (4)      (3) (1)
//----------------------------------------------------------------------------
//  next flit   | eop |res| wdidx |           nline                          |
//    (40)        (1)  (1)  (4)                (34)
//----------------------------------------------------------------------------
//  next flits  | eop |   res    | be |     wdata                            |
//    (40)        (1)     (3)      (4)      (32)
//////////////////////////////////////////////////////////////////////////////
//   Ring : Cleanup Ack 1 flit  l2(1)-l1(n)                                 //
//----------------------------------------------------------------------------
//  1st flit    | eop | procid          |res|    set        | way   | type |0|
//     (40)       (1)   (14)             (1)     (16)         (4)      (3) (1)
//----------------------------------------------------------------------------
// Type         | cleanup ACK | Update/Inval | Data/instr |
//  (3)               (1)          (1)           (1) 
////////////////////////////////////////////////////////////////////
//   Ring : cleanup 2 flits l1(n)->l2(1)                          //
//------------------------------------------------------------------
//  1st flit    | eop | clustid*| procid | nline  | way    | type  |
//     (33)       (1)    (10)     (14)     (2)      (4)     (2)    
//  next flit   | eop |                       nline                |
//    (33)        (1)                          (32)                            
/////////////////////////////////////////////////////////////////////
//   Ring : multicast ack 1 flit l1(n)->l2(1)                      //
//------------------------------------------------------------------
//  1st flit    | eop | clustid*|    res          | trdid  | type  |
//     (33)       (1)    (10)        (16)           (4)     (2)    
//------------------------------------------------------------------
// Type         | cleanup/MulticastACK | Data/instr |
//  (2)               (1)               (1)
// *clusterid : identifiy cluster id of the dest memory cache.
// all memory caches have the same Identifier in their clusters.
//------------------------------------------------------------------

#ifndef SOCLIB_CABA_DSPIN_SIMPLE_RING_INITIATOR_FAST_C_H
#define SOCLIB_CABA_DSPIN_SIMPLE_RING_INITIATOR_FAST_C_H

#include "generic_fifo.h"
#include "mapping_table.h"
#include "ring_signals_fast.h"
#include "dspin_interface.h"

#define I_DEBUG

namespace soclib { namespace caba {

namespace {

const char *ring_cmd_fsm_state_str_si[] = {
                "CMD_IDLE",
                "DEFAULT",
                "BDC_FIRST",
                "BDC_SECOND",
                "KEEP",
};

#ifdef I_DEBUG

const char *ring_rsp_fsm_state_str_si[] = {
        "RSP_IDLE",
        "LOCAL",
        "RING",
};
#endif
} // end namespace

template<typename vci_param, int ring_cmd_data_size, int ring_rsp_data_size>
class DspinSimpleRingInitiatorFastC
{

typedef SimpleRingSignals                ring_signal_t;
typedef DspinInput<ring_cmd_data_size>   cmd_in_t;
typedef DspinOutput<ring_rsp_data_size>  rsp_out_t;

private:
        enum ring_rsp_fsm_state_e {
            	RSP_IDLE,    // waiting for first flit of a response packet
            	LOCAL,       // next flit of a local rsp packet
            	RING,  	     // next flit of a ring rsp packet
            };
        
        enum ring_cmd_fsm_state_e {
            	CMD_IDLE,	    
             	DEFAULT,  
                BDC_FIRST,
                BDC_SECOND,	
            	KEEP,          	    
            };
        
        // structural parameters
        std::string  m_name;
        bool         m_alloc_init;


        // internal fifos 
        GenericFifo<uint64_t > m_cmd_fifo;     // fifo for the local command packet
        GenericFifo<uint64_t > m_rsp_fifo;     // fifo for the local response packet
        
        // routing table
        //soclib::common::AddressMaskingTable<uint32_t> m_rt;
        //soclib::common::AddressDecodingTable<uint32_t, bool> m_lt;

	uint64_t r_brdcst_save; 
        //uint32_t m_srcid;
        uint32_t m_nb_target;

        sc_core::sc_signal<uint32_t> r_cpt_tgt;         // target id for sequential broadcast
        sc_core::sc_signal<uint32_t> r_ring_cmd_fsm;    // ring command  (l2->l1) packet FSM 
        sc_core::sc_signal<uint32_t> r_ring_rsp_fsm;    // ring response (l1->l2) packet FSM

public :

#define __renRegInitS(x) x((((std::string) name)+"_" #x).c_str())

DspinSimpleRingInitiatorFastC(
	const char     *name,
        bool            alloc_init,
        const int       &wrapper_fifo_depth,
	const uint32_t &nb_target)
      : m_name(name),
        m_alloc_init(alloc_init),
        m_cmd_fifo(((std::string) name)+"m_cmd_fifo", wrapper_fifo_depth),
        m_rsp_fifo(((std::string) name)+"m_rsp_fifo", wrapper_fifo_depth),
        //m_rt(mt.getIdMaskingTable(ringid.level())),
        //m_lt(mt.getIdLocalityTable(ringid)),
        //m_srcid(srcid),
	m_nb_target(nb_target),
        __renRegInitS(r_cpt_tgt),
        __renRegInitS(r_ring_cmd_fsm),
        __renRegInitS(r_ring_rsp_fsm)
  
 {} //  end constructor

 void reset()
{
	if(m_alloc_init)
		r_ring_cmd_fsm = DEFAULT;
	else
		r_ring_cmd_fsm = CMD_IDLE;

	r_ring_rsp_fsm = RSP_IDLE;
	m_cmd_fifo.init();
	m_rsp_fifo.init();
 }

void transition(const cmd_in_t &p_cmd_in, const rsp_out_t &p_rsp_out, const ring_signal_t p_ring_in, cmd_str &init_cmd, bool &init_rsp_val)
{

	bool      cmd_fifo_get = false;
	bool      cmd_fifo_put = false;
	uint64_t  cmd_fifo_data = 0;

	bool      rsp_fifo_put = false;
	uint64_t  rsp_fifo_data = 0;

//////////// ACCESS DSPIN FIFOS  ///////////////////
	if (p_cmd_in.write.read()) {
#ifdef I_DEBUG
std::cout << sc_time_stamp() << " -- " << m_name << " -- DSPIN FIFO" 
          << " -- cmd in rok : " << p_cmd_in.write
          << " --  in data  : " << std::hex << p_cmd_in.data.read()
          << " --  fifo wok : "  << m_cmd_fifo.wok()          
          << std::endl;
#endif
		cmd_fifo_data = (uint64_t) p_cmd_in.data.read();
		cmd_fifo_put =  m_cmd_fifo.wok();
	}

	bool rsp_fifo_get = p_rsp_out.read.read();
//////////// RING CMD FSM /////////////////////////
	switch( r_ring_cmd_fsm ) 
	{
		case CMD_IDLE:   
#ifdef I_DEBUG
std::cout << sc_time_stamp() << " -- " << m_name << " -- r_ring_cmd_fsm : CMD_IDLE " 
          << " -- in grant : " << p_ring_in.cmd_grant
          << " -- fifo rok : " << m_cmd_fifo.rok()
          << " -- fifo data : " << std::hex << m_cmd_fifo.read()          
          << std::endl;
#endif 
			if ( p_ring_in.cmd_grant && m_cmd_fifo.rok() )  
                        {


                                if (m_cmd_fifo.read() & 0x1 == 0x1) // broadcast
                                {
                                        r_cpt_tgt      = 0;                   
                                        r_brdcst_save  = m_cmd_fifo.read(); // save first flit of brdcst
                                        r_ring_cmd_fsm = BDC_FIRST;                                  

                                } else {
                        		r_ring_cmd_fsm = KEEP; 
                                }
                        }
		break;

		case DEFAULT:
 
			if ( m_cmd_fifo.rok()) // && p_ring_in.cmd_wok.read() ) 
			{
#ifdef I_DEBUG
std::cout << sc_time_stamp() << " -- " << m_name 
          << " -- r_ring_cmd_fsm : DEFAULT "
          << " -- in grant   : " << p_ring_in.cmd_grant
          << " -- fifo rok : " << m_cmd_fifo.rok()
          << " -- fifo_cmd_data : " << std::hex << m_cmd_fifo.read()
          << std::endl;
#endif 
                        	bool eop = ( (int) ((m_cmd_fifo.read() >> (ring_cmd_data_size - 1) ) & 0x1) == 1);

                                if (m_cmd_fifo.read() & 0x1 == 0x1) // broadcast
                                {
                                        r_cpt_tgt      = 0;                   
                                        r_brdcst_save  = m_cmd_fifo.read(); // save first flit of brdcst
                                        r_ring_cmd_fsm = BDC_FIRST;                                        
                                } 
//
				else
				{
					if ( eop && p_ring_in.cmd_r )  
					 {
					 	cmd_fifo_get = true;
					        if ( p_ring_in.cmd_grant )
					 	        r_ring_cmd_fsm = DEFAULT;
					      	else
					 	        r_ring_cmd_fsm = CMD_IDLE;
					 }  
					
					 if (!eop || !p_ring_in.cmd_r) 
					 {
					 	cmd_fifo_get = p_ring_in.cmd_r;
					 	r_ring_cmd_fsm = KEEP;
					 }

				}
             
			}   
			else if ( !p_ring_in.cmd_grant)
				r_ring_cmd_fsm = CMD_IDLE; 
		break;

                case BDC_FIRST:
                       
#ifdef I_DEBUG
std::cout << sc_time_stamp() << " -- " << m_name << " -- r_ring_cmd_fsm : BDC_FIRST "
          << " -- in grant   : " << p_ring_in.cmd_grant
          << " -- cpt_tgt : " << r_cpt_tgt
          << " -- fifo rok : " << m_cmd_fifo.rok()
          << " -- in wok : " << p_ring_in.cmd_r
          << " -- fifo_cmd_data : " << std::hex << m_cmd_fifo.read()
          << std::endl;
#endif

                        if (p_ring_in.cmd_r)                                 
			{
                        	if (r_cpt_tgt.read() == 0)
				{
                                	cmd_fifo_get = true;
				}
                                r_ring_cmd_fsm = BDC_SECOND;
			}
                break;

                case BDC_SECOND:
#ifdef I_DEBUG
std::cout << sc_time_stamp() << " -- " << m_name << " -- r_ring_cmd_fsm : BDC_SECOND "
          << " -- in grant   : " << p_ring_in.cmd_grant
          << " -- fifo rok : " << m_cmd_fifo.rok()
          << " -- in wok : " << p_ring_in.cmd_r
          << " -- fifo_cmd_data : " << std::hex << m_cmd_fifo.read()
          << std::endl;
#endif
          		if(m_cmd_fifo.rok() && p_ring_in.cmd_r)
			{ 
				if(r_cpt_tgt.read() == m_nb_target - 1)
				{
					cmd_fifo_get = true;  

					if ( p_ring_in.cmd_grant )
						r_ring_cmd_fsm = DEFAULT;  
					else   
						r_ring_cmd_fsm = CMD_IDLE;
				}
				else
				{
					r_cpt_tgt      = r_cpt_tgt + 1;
                                	r_ring_cmd_fsm = BDC_FIRST;
				}

			}
                break;

		case KEEP:   
#ifdef I_DEBUG
std::cout << std::dec << sc_time_stamp() << " - " << m_name
                  << " - r_ring_cmd_fsm = " << ring_cmd_fsm_state_str_si[r_ring_cmd_fsm] 
                  << " -- in grant : " << p_ring_in.cmd_grant  
                  << " -- fifo ROK : " << m_cmd_fifo.rok()
                  << " -- in wok : " << p_ring_in.cmd_r
                  << " -- fifo data : " << std::hex << m_cmd_fifo.read()
                  << std::endl;
#endif                        
			if(m_cmd_fifo.rok() && p_ring_in.cmd_r ) 
			{
				cmd_fifo_get = true;  
				if (((int) (m_cmd_fifo.read() >> (ring_cmd_data_size - 1) ) & 0x1) == 1)  // 39
				{  
					if ( p_ring_in.cmd_grant )
						r_ring_cmd_fsm = DEFAULT;  
					else   
						r_ring_cmd_fsm = CMD_IDLE; 
				}        
			}      
		break;

	} // end switch ring cmd fsm
 
/////////// RING RSP FSM ////////////////////////
    
	switch( r_ring_rsp_fsm ) 
	{
		case RSP_IDLE:  
		{
 
			//uint32_t  rsrcid  = (uint32_t)  ((sc_dt::sc_uint<vci_param::S>) ((p_ring_in.rsp_data >> (ring_rsp_data_size - 1)) << (vci_param::S)));
			bool      islocal = true; // m_lt[rsrcid] && (m_rt[rsrcid] == m_srcid);
			bool      reop    = ((p_ring_in.rsp_data >> (ring_rsp_data_size - 1)) & 0x1) == 1; 
#ifdef I_DEBUG
if(p_ring_in.rsp_w) {
        std::cout << std::dec << sc_time_stamp() << " - " << m_name
                  << " - r_ring_rsp_fsm = " << ring_rsp_fsm_state_str_si[r_ring_rsp_fsm]
                  << " -- in rok : " << p_ring_in.rsp_w
                  << " -- in wok : " << p_ring_in.rsp_r
                  << " -- fifo wok : " <<  m_rsp_fifo.wok() 
                  << " -- in data : " << std::hex << p_ring_in.rsp_data
                  << std::endl;
}
#endif

			if (p_ring_in.rsp_w  &&  islocal) 
			{  
 
				rsp_fifo_put  = m_rsp_fifo.wok();
				rsp_fifo_data = p_ring_in.rsp_data;

                                if (reop && m_rsp_fifo.wok())
                                        r_ring_rsp_fsm = RSP_IDLE;
                                else
                                        r_ring_rsp_fsm = LOCAL;

			}

			else    if (p_ring_in.rsp_w  &&  !islocal) 
			        {

                                        if (reop && p_ring_in.rsp_r)
                                                r_ring_rsp_fsm = RSP_IDLE;
                                        else
                                                r_ring_rsp_fsm = RING;
			        }

			        else // !p_ring_in.rsp_w 
			        {			
			        	r_ring_rsp_fsm = RSP_IDLE;
		        	}
		}
		break;

		case LOCAL:
		{
#ifdef I_DEBUG
if(p_ring_in.rsp_w)
        std::cout << std::dec << sc_time_stamp() << " - " << m_name
                  << " - r_ring_rsp_fsm = " << ring_rsp_fsm_state_str_si[r_ring_rsp_fsm]
                  << " -- in rok : " << p_ring_in.rsp_w
                  << " -- in wok : " << p_ring_in.rsp_r
                  << " -- fifo wok : " <<  m_rsp_fifo.wok() 
                  << " -- in data : " << std::hex << p_ring_in.rsp_data
                  << std::endl;
#endif 

			bool reop     = ((p_ring_in.rsp_data >> (ring_rsp_data_size - 1)) & 0x1) == 1;

			if (p_ring_in.rsp_w && m_rsp_fifo.wok() && reop)         
			{

				rsp_fifo_put  = true;
				rsp_fifo_data = p_ring_in.rsp_data;
				r_ring_rsp_fsm = RSP_IDLE;             
			}
			if (!p_ring_in.rsp_w || !m_rsp_fifo.wok() || !reop)         
			{

				rsp_fifo_put  = p_ring_in.rsp_w && m_rsp_fifo.wok();
				rsp_fifo_data = p_ring_in.rsp_data;
				r_ring_rsp_fsm = LOCAL;             
			}
		} 
		break;

		case RING:    
		{
#ifdef I_DEBUG
if(p_ring_in.rsp_w)
        std::cout << std::dec << sc_time_stamp() << " - " << m_name
                  << " - r_ring_rsp_fsm = " << ring_rsp_fsm_state_str_si[r_ring_rsp_fsm]
                  << " -- in rok : " << p_ring_in.rsp_w
                  << " -- in wok : " << p_ring_in.rsp_r
                  << " -- fifo wok : " <<  m_rsp_fifo.wok() 
                  << " -- in data : " << std::hex << p_ring_in.rsp_data
                  << std::endl;
#endif 
			bool reop     = ((p_ring_in.rsp_data >> (ring_rsp_data_size - 1)) & 0x1) == 1;

			if (p_ring_in.rsp_w && reop && p_ring_in.rsp_r)
			{
				r_ring_rsp_fsm = RSP_IDLE; 
			}
			else
			{
				r_ring_rsp_fsm = RING;
			}
		}	
		break;

	} // end switch rsp fsm

////////////////////////
//  fifos update      //
////////////////////////
//-- to keep trace on ring traffic : a valid initiator command is being sent
        init_cmd.cmdval  = cmd_fifo_get;
        init_cmd.flit    = m_cmd_fifo.read();
        init_cmd.state   = ring_cmd_fsm_state_str_si[r_ring_cmd_fsm]; 
 
	//init_cmd_val = cmd_fifo_get;
	init_rsp_val = rsp_fifo_put;
// local cmd fifo update
	if (  cmd_fifo_put &&  cmd_fifo_get ) m_cmd_fifo.put_and_get(cmd_fifo_data);
	else if (  cmd_fifo_put && !cmd_fifo_get ) m_cmd_fifo.simple_put(cmd_fifo_data);
	else if ( !cmd_fifo_put &&  cmd_fifo_get ) m_cmd_fifo.simple_get();
	
// local rsp fifo update
	if (  rsp_fifo_put &&  rsp_fifo_get ) m_rsp_fifo.put_and_get(rsp_fifo_data);
	else if (  rsp_fifo_put && !rsp_fifo_get ) m_rsp_fifo.simple_put(rsp_fifo_data);
	else if ( !rsp_fifo_put &&  rsp_fifo_get ) m_rsp_fifo.simple_get();
     
}  // end Transition()

///////////////////////////////////////////////////////////////////
void genMoore(cmd_in_t &p_cmd_in, rsp_out_t &p_rsp_out)
///////////////////////////////////////////////////////////////////
{
	p_rsp_out.write = m_rsp_fifo.rok();
	p_rsp_out.data  = (sc_dt::sc_uint<ring_rsp_data_size>) m_rsp_fifo.read();

	p_cmd_in.read= m_cmd_fifo.wok();

} // end genMoore
/////////////////////////////////////////////////////////////////////////////
void update_ring_signals(ring_signal_t p_ring_in, ring_signal_t &p_ring_out)
////////////////////////////////////////////////////////////////////////////
{    
	switch( r_ring_cmd_fsm ) 
	{
		case CMD_IDLE:
			p_ring_out.cmd_grant = p_ring_in.cmd_grant && !m_cmd_fifo.rok();

        		p_ring_out.cmd_w     = p_ring_in.cmd_w;
	        	p_ring_out.cmd_data  = p_ring_in.cmd_data;
		break;
	
		case DEFAULT:       
		{
                        bool eop = ((int) ((m_cmd_fifo.read() >> (ring_cmd_data_size - 1) ) & 0x1) == 1);
                        bool brdcst = (m_cmd_fifo.read() & 0x1 == 0x1);

			p_ring_out.cmd_grant = (!m_cmd_fifo.rok() || (eop && p_ring_in.cmd_r)) ;  

	        	p_ring_out.cmd_w    =  m_cmd_fifo.rok() && !brdcst;
		        p_ring_out.cmd_data =  m_cmd_fifo.read();
		}
		break;

	       	case BDC_FIRST:
			p_ring_out.cmd_grant = false;
			p_ring_out.cmd_w     = true;
			p_ring_out.cmd_data  =  r_brdcst_save | ((((uint64_t) r_cpt_tgt.read()) & 0xF) << 0x1);     
                break;
		
		case BDC_SECOND:			
			p_ring_out.cmd_grant = m_cmd_fifo.rok() && p_ring_in.cmd_r && (r_cpt_tgt.read() == m_nb_target - 1);
       			p_ring_out.cmd_w    =  m_cmd_fifo.rok();
	        	p_ring_out.cmd_data =  m_cmd_fifo.read();

		break;

		case KEEP: 
		{ 
			int cmd_fifo_eop = (int) ((m_cmd_fifo.read() >> (ring_cmd_data_size - 1)) & 0x1) ; //39
			p_ring_out.cmd_grant = m_cmd_fifo.rok() && p_ring_in.cmd_r && (cmd_fifo_eop == 1);

        		p_ring_out.cmd_w    =  m_cmd_fifo.rok();
	        	p_ring_out.cmd_data =  m_cmd_fifo.read();
		}
		break;
	
	} // end switch

	p_ring_out.cmd_r       = p_ring_in.cmd_r;

	p_ring_out.rsp_grant   = p_ring_in.rsp_grant;
	p_ring_out.rsp_w       = p_ring_in.rsp_w;
	p_ring_out.rsp_data    = p_ring_in.rsp_data;

	switch( r_ring_rsp_fsm ) 
	{
		case RSP_IDLE:	
		{
 
			//uint32_t  rsrcid  = (uint32_t)  ((sc_dt::sc_uint<vci_param::S>) ((p_ring_in.rsp_data >> (ring_rsp_data_size-m_x_width-m_y_width - 1)) << (vci_param::S-m_x_width-m_y_width)));
			bool      islocal = true; //m_lt[rsrcid] && (m_rt[rsrcid] == m_srcid);

			if(p_ring_in.rsp_w && islocal) 
				p_ring_out.rsp_r = m_rsp_fifo.wok();
                        else
				p_ring_out.rsp_r = p_ring_in.rsp_r;
		}
		break;
	
		case LOCAL:
			p_ring_out.rsp_r = m_rsp_fifo.wok();
		break;
	
		case RING:
			p_ring_out.rsp_r = p_ring_in.rsp_r;
		break;    
	} // end switch


} // end update_ring_signals

};

}} // end namespace
#endif // SOCLIB_CABA_DSPIN_SIMPLE_RING_INITIATOR_FAST_C_H


