/*
   This file is part of MutekP.
  
   MutekP is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   MutekP is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with MutekP; if not, write to the Free Software Foundation,
   Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
  
   UPMC / LIP6 / SOC (c) 2009
   Copyright Ghassan Almaless <ghassan.almaless@gmail.com>
*/


/////////////////////////////////////////
//   Devices mapped segments 
/////////////////////////////////////////
#define     TIMER0_BASE  0x03200000
#define     TIMER0_SIZE  0x00000080

#define     TIMER1_BASE  0x63200000
#define     TIMER1_SIZE  0x00000080

#define     TIMER2_BASE  0x83200000
#define     TIMER2_SIZE  0x00000080

#define     TIMER3_BASE  0xC3200000
#define     TIMER3_SIZE  0x00000080

#define     ICU_BASE    0x93400000
#define     ICU_SIZE    0x00000020

#define	    DMA_BASE	0xB3200000
#define	    DMA_SIZE	0x00000014

#define     TTY_BASE    0x95200000
#define     TTY_SIZE    0x00000100

#define     BD_BASE     0xB7200000
#define     BD_SIZE     0x20

#define FB_XSIZE 512
#define FB_YSIZE 512
#define	FB_BASE	0xD2200000
#define	FB_SIZE	FB_XSIZE*FB_YSIZE*2
////////////////////////////////////////


//////////////////////////////////////////
//       ROM mapped segments
//////////////////////////////////////////

#define    KTEXT_LMA_BASE  0xbf800000
#define    KTEXT_LMA_SIZE  0x00020000

#define    KDATA_LMA_BASE  0xbf820000
#define    KDATA_LMA_SIZE  0x00020000

#define    UTEXT_LMA_BASE  0xbf840000
#define    UTEXT_LMA_SIZE  0x00060000

#define    UDATA_LMA_BASE  0xbf8A0000
#define    UDATA_LMA_SIZE  0x00020000

#define    BOOT_BASE       0xbfc00000
#define    BOOT_SIZE       0x00100000
//////////////////////////////////////////

//////////////////////////////////////////
//                RAM
//////////////////////////////////////////

//#define     RAM_BASE    0x7F400000
//#define     RAM_SIZE    0x01000000
#define MC0_M_BASE	0x10000000
//#define MC0_M_SIZE	0x00400000
#define MC0_M_SIZE	0x01000000

#define MC1_M_BASE	0x50000000
//#define MC1_M_SIZE	0x00400000
#define MC1_M_SIZE	0x01000000

#define MC2_M_BASE	0x80000000
//#define MC2_M_SIZE	0x00400000
#define MC2_M_SIZE	0x01000000

#define MC3_M_BASE	0xD0000000
//#define MC3_M_SIZE	0x00400000
#define MC3_M_SIZE	0x01000000


//////////////////////////////////////////

//////////////////////////////////////////
//    Application mapped segments
//////////////////////////////////////////

#define  KTEXT_BASE       0x80000000
#define  KDATA_BASE       0x80020000
#define  KDATA_SIZE       0x003E0000

#define     USR_TEXT_BASE    0x7F400000
#define     USR_DATA_BASE    0x7F460000
#define     USR_DATA_SIZE    0X00B9F000
////////////////////////////////////////

////////////////////////////////////////
//	Reserved segments
////////////////////////////////////////

#define PROC0_BASE	0x01400000
#define PROC0_SIZE	0x00000020

#define PROC1_BASE	0x02400000
#define PROC1_SIZE	0x00000020

#define PROC2_BASE	0x03400000
#define PROC2_SIZE	0x00000020

#define PROC3_BASE	0x04400000
#define PROC3_SIZE	0x00000020

#define PROC4_BASE	0x43400000
#define PROC4_SIZE	0x00000020

#define PROC5_BASE	0x44400000
#define PROC5_SIZE	0x00000020

#define PROC6_BASE	0x45400000
#define PROC6_SIZE	0x00000020

#define PROC7_BASE	0x46400000
#define PROC7_SIZE	0x00000020

#define PROC8_BASE	0xA3400000
#define PROC8_SIZE	0x00000020

#define PROC9_BASE	0xA4400000
#define PROC9_SIZE	0x00000020

#define PROC10_BASE	0xA5400000
#define PROC10_SIZE	0x00000020

#define PROC11_BASE	0xA6400000
#define PROC11_SIZE	0x00000020

#define PROC12_BASE	0xE2400000
#define PROC12_SIZE	0x00000020

#define PROC13_BASE	0xE3400000
#define PROC13_SIZE	0x00000020

#define PROC14_BASE	0xE4400000
#define PROC14_SIZE	0x00000020

#define PROC15_BASE	0xE5400000
#define PROC15_SIZE	0x00000020


////////////////////////////////////////
