#include "benchmark.h"
#include "system.h"
#include "stdio.h"
#include "../common/common.h"

void benchmark (void)
{
  /* if(procnum() != 0) */
  /*   EXIT(0); */

  int result = 0;
  int cycle_begin = cycle_begin = cpu_cycles();

  switch (procnum())
    {
    default :
      {
#if BENCHMARK_MATRIX_MULTIPLICATION_MT
        int result_mm_mt = benchmark_matrix_multiplication_mt();
        result += result_mm_mt;
#endif
#if BENCHMARK_DHRYSTONE
        int result_dhrystone = benchmark_dhrystone();
        result += result_dhrystone;
#endif
#if BENCHMARK_SORT
        int result_sort = benchmark_sort();
        result += result_sort;
#endif
#if BENCHMARK_MATRIX_MULTIPLICATION_ST
        int result_mm_st = benchmark_matrix_multiplication_st();
        result += result_mm_st;
#endif

        printf("\n");
        printf("--------------------------------\n");
        printf( "Partial results :\n");
#if BENCHMARK_MATRIX_MULTIPLICATION_MT
        printf(" * MM MT           : %d\n",result_mm_mt);
#endif
#if BENCHMARK_DHRYSTONE
        printf(" * DHRYSTONE       : %d\n",result_dhrystone);
#endif
#if BENCHMARK_SORT
        printf(" * SORT            : %d\n",result_sort);
#endif
#if BENCHMARK_MATRIX_MULTIPLICATION_ST
        printf(" * MM ST           : %d\n",result_mm_st);
#endif 
        printf("--------------------------------\n");
       break;
      }
    }

  printf("\n");
  printf("================================\n");
  printf( "Results :\n");
  printf( " * Score           : %d\n", result);
  printf( " * Total CPU Cycle : %d\n", cpu_cycles()-cycle_begin);
  printf("================================\n");
}
