#!/bin/bash

#               archi1  archi2  archi3  archi4
archi_name=(    "00512" "16384" "01024" "02048");
iways=(         "1"     "4"     "16"    "4"    );
isets=(         "8"     "64"    "1"     "8"    );
iwords=(        "16"    "16"    "16"    "16"   );
dways=(         "1"     "4"     "16"    "4"    );
dsets=(         "8"     "64"    "1"     "8"    );
dwords=(        "16"    "16"    "16"    "16"   );
memc_nways=(    "4"     "16"    "8"     "2"    );
memc_nsets=(    "4"     "256"   "64"    "32"   );
memc_words=(    "16"    "16"    "16"    "16"   );
memc_heap_size=("4096"  "4096"  "4096"  "4096" );

nb_proc=( "1" "15" "+1" "4");
wnwords=( "1" "16" "*2" "8");
wnlines=( "1" "8"  "*2" "8");
wtimeout=("1" "1024" "*4" "16");

archi_default="1";

function gen_file ()
{
        filename=$(printf "x%.2d-xcache_%s-wbuf_%.2d_%.2d_%.4d.cfg" ${1} ${archi_name[${2}]} ${3} ${4} ${5});

        echo ${filename};

        echo "${1}" > ${filename};
        echo "${iways[${2}]} ${isets[${2}]} ${iwords[${2}]}" >> ${filename};
        echo "${dways[${2}]} ${dsets[${2}]} ${dwords[${2}]}" >> ${filename};
        echo "${3} ${4} ${5}" >> ${filename};
        echo "${memc_nways[${2}]} ${memc_nsets[${2}]} ${memc_words[${2}]} ${memc_heap_size[${2}]}" >> ${filename};
}

function gen_default ()
{
        filename="default.cfg";
        archi=${1};

        echo ${filename};

        echo "${nb_proc[3]}" > ${filename};
        echo "${iways[${archi}]} ${isets[${archi}]} ${iwords[${archi}]}" >> ${filename};
        echo "${dways[${archi}]} ${dsets[${archi}]} ${dwords[${archi}]}" >> ${filename};
        echo "${wnwords[3]} ${wnlines[3]} ${wtimeout[3]}" >> ${filename};
        echo "${memc_nways[${archi}]} ${memc_nsets[${archi}]} ${memc_words[${archi}]} ${memc_heap_size[${archi}]}" >> ${filename};
}

gen_default ${archi_default};

nb_archi=${#iways[*]};

num_archi=0;
while test ${num_archi} -lt ${nb_archi}; do
    num_proc=${nb_proc[0]};
    while test ${num_proc} -le ${nb_proc[1]}; do
        num_words=${wnwords[0]};
        while test ${num_words} -le ${wnwords[1]}; do
            num_lines=${wnlines[0]};
            while test ${num_lines} -le ${wnlines[1]}; do
                num_timeout=${wtimeout[0]};
                while test ${num_timeout} -le ${wtimeout[1]}; do

                    gen_file ${num_proc} ${num_archi} ${num_words} ${num_lines} ${num_timeout};

                    num_timeout=$((${num_timeout} ${wtimeout[2]}));
                done;
                num_lines=$((${num_lines} ${wnlines[2]}));
            done;
            num_words=$((${num_words} ${wnwords[2]}));
        done;
        num_proc=$((${num_proc} ${nb_proc[2]}));
    done;
    num_archi=$((${num_archi}+1));
done;


