
#include <systemc>
#include <sys/time.h>
#include <iostream>
#include <cstdlib>
#include <cstdarg>

#include "mapping_table.h"
#include "mips32.h"
#include "vci_simple_ram.h"
#include "vci_multi_tty.h"
#include "vci_simple_ring_fast.h"
#include "vci_vgmn.h"
#include "vci_mem_cache_v2.h"
#include "vci_cc_xcache_wrapper_v1.h"
#include "vci_logger.h"
#include "vci_xicu.h"

#define USE_GDB_SERVER

#ifdef USE_GDB_SERVER
#include "gdbserver.h"
#endif

//#define  VCI_LOGGER_ON_L1
//#define  VCI_LOGGER_ON_ROM
//#define VCI_LOGGER_ON_DMA

// If you want to use the VGMN or the RING
//#define USE_VGMN

#define CYCLES 100000

#include "segmentation.h"

int _main(int argc, char *argv[])
{
	using namespace sc_core;
	// Avoid repeating these everywhere
	using soclib::common::IntTab;
	using soclib::common::Segment;

	// Define VCI parameters
	typedef soclib::caba::VciParams<4,8,32,1,1,1,8,4,4,1> vci_param;
	typedef soclib::common::Mips32ElIss ProcessorIss;
#ifdef USE_GDB_SERVER
        typedef soclib::common::GdbServer<ProcessorIss> proc_iss;
#else
	typedef ProcessorIss proc_iss;
#endif
	// Mapping table
        soclib::common::MappingTable maptabp(32, IntTab(8), IntTab(8), 0xFF000000);
        maptabp.add(Segment("resetmips", 0xbfc00000, 0x2000, IntTab(0), true));
        maptabp.add(Segment("excep", 0x80000000, 0x100000, IntTab(0), true));

        maptabp.add(Segment("text" ,     0x60100000, 0x00100000, IntTab(1), true));
        maptabp.add(Segment("data",      0x71600000, 0x01000000, IntTab(1), true));
        maptabp.add(Segment("rodata" ,   0x61100000, 0x01000000, IntTab(1), true));

        maptabp.add(Segment("tty"  ,     0x90600000, 0x00000010, IntTab(2), false));
        maptabp.add(Segment("xicu",      0x20600000, 0x00001000, IntTab(3), false));

 
	std::cout << maptabp << std::endl;

        soclib::common::MappingTable maptabc(32, IntTab(8), IntTab(8), 0xFF000000);
	maptabc.add(Segment("c_proc0" , PROC0_BASE , PROC0_SIZE , IntTab(0), false, true, IntTab(0)));
	maptabc.add(Segment("c_proc1" , PROC1_BASE , PROC1_SIZE , IntTab(1), false, true, IntTab(1)));
	maptabc.add(Segment("c_proc2" , PROC2_BASE , PROC2_SIZE , IntTab(2), false, true, IntTab(2)));
	maptabc.add(Segment("c_proc3" , PROC3_BASE , PROC3_SIZE , IntTab(3), false, true, IntTab(3)));

        maptabc.add(Segment("resetmips", 0xbfc00000, 0x2000, IntTab(4), false));
        maptabc.add(Segment("excep", 0x80000000, 0x100000, IntTab(4), true));

        maptabc.add(Segment("text" ,     0x60100000, 0x00100000, IntTab(4), false));
        maptabc.add(Segment("data",      0x71600000, 0x01000000, IntTab(4), false));
        maptabc.add(Segment("rodata" ,   0x61100000, 0x01000000, IntTab(4), false));



	std::cout << maptabc << std::endl;
	
	soclib::common::MappingTable maptabx(32, IntTab(8), IntTab(8), 0x30000000);
	maptabx.add(Segment("data" , 0x71600000 , 0x01000000 , IntTab(0), false));
	maptabx.add(Segment("text" , 0x60100000 , 0x00100000 , IntTab(0), false));
	maptabx.add(Segment("rodata" , 0x61100000 , 0x01000000 , IntTab(0), false));
	
	
	std::cout << maptabx << std::endl;

	// Signals

	sc_clock	signal_clk("clk");
	sc_signal<bool> signal_resetn("resetn");
   
	sc_signal<bool> signal_proc0_it0("proc0_it0"); 
	sc_signal<bool> signal_proc0_it1("proc0_it1"); 
	sc_signal<bool> signal_proc0_it2("proc0_it2"); 
	sc_signal<bool> signal_proc0_it3("proc0_it3"); 
	sc_signal<bool> signal_proc0_it4("proc0_it4"); 
	sc_signal<bool> signal_proc0_it5("proc0_it5");

	sc_signal<bool> signal_proc1_it0("proc1_it0"); 
	sc_signal<bool> signal_proc1_it1("proc1_it1"); 
	sc_signal<bool> signal_proc1_it2("proc1_it2"); 
	sc_signal<bool> signal_proc1_it3("proc1_it3"); 
	sc_signal<bool> signal_proc1_it4("proc1_it4"); 
	sc_signal<bool> signal_proc1_it5("proc1_it5");

	sc_signal<bool> signal_proc2_it0("proc2_it0"); 
	sc_signal<bool> signal_proc2_it1("proc2_it1"); 
	sc_signal<bool> signal_proc2_it2("proc2_it2"); 
	sc_signal<bool> signal_proc2_it3("proc2_it3"); 
	sc_signal<bool> signal_proc2_it4("proc2_it4"); 
	sc_signal<bool> signal_proc2_it5("proc2_it5");

	sc_signal<bool> signal_proc3_it0("proc3_it0"); 
	sc_signal<bool> signal_proc3_it1("proc3_it1"); 
	sc_signal<bool> signal_proc3_it2("proc3_it2"); 
	sc_signal<bool> signal_proc3_it3("proc3_it3"); 
	sc_signal<bool> signal_proc3_it4("proc3_it4"); 
	sc_signal<bool> signal_proc3_it5("proc3_it5");


	soclib::caba::VciSignals<vci_param> signal_vci_ini_rw_proc0("vci_ini_rw_proc0");
	soclib::caba::VciSignals<vci_param> signal_vci_ini_c_proc0("vci_ini_c_proc0");

	soclib::caba::VciSignals<vci_param> signal_vci_tgt_proc0("vci_tgt_proc0");

	soclib::caba::VciSignals<vci_param> signal_vci_ini_rw_proc1("vci_ini_rw_proc1");
	soclib::caba::VciSignals<vci_param> signal_vci_ini_c_proc1("vci_ini_c_proc1");

	soclib::caba::VciSignals<vci_param> signal_vci_tgt_proc1("vci_tgt_proc1");

	soclib::caba::VciSignals<vci_param> signal_vci_ini_rw_proc2("vci_ini_rw_proc2");
	soclib::caba::VciSignals<vci_param> signal_vci_ini_c_proc2("vci_ini_c_proc2");

	soclib::caba::VciSignals<vci_param> signal_vci_tgt_proc2("vci_tgt_proc2");

	soclib::caba::VciSignals<vci_param> signal_vci_ini_rw_proc3("vci_ini_rw_proc3");
	soclib::caba::VciSignals<vci_param> signal_vci_ini_c_proc3("vci_ini_c_proc3");
	soclib::caba::VciSignals<vci_param> signal_vci_tgt_proc3("vci_tgt_proc3");


	soclib::caba::VciSignals<vci_param> signal_vci_tty("signal_vci_tty");
	soclib::caba::VciSignals<vci_param> signal_vci_vcitimer("signal_vci_vcitimer");
	
	soclib::caba::VciSignals<vci_param> signal_vci_icu("signal_vci_icu");
	soclib::caba::VciSignals<vci_param> signal_vci_dmai("signal_vci_dmai");
	soclib::caba::VciSignals<vci_param> signal_vci_dmat("signal_vci_dmat");
	soclib::caba::VciSignals<vci_param> signal_vci_simhelper("signal_vci_simhelper");
	soclib::caba::VciSignals<vci_param> signal_vci_tgt_rom("vci_tgt_rom");

	soclib::caba::VciSignals<vci_param> signal_vci_tgt_xram("vci_tgt_xram");

	soclib::caba::VciSignals<vci_param> signal_vci_ini_memc("vci_ini_memc");
	soclib::caba::VciSignals<vci_param> signal_vci_tgt_memc("vci_tgt_memc");
	soclib::caba::VciSignals<vci_param> signal_vci_tgt_cleanup_memc("vci_tgt_cleanup_memc");

	sc_signal<bool> signal_icu_irq0("signal_icu_irq0");
	sc_signal<bool> signal_icu_irq1("signal_icu_irq1");
	sc_signal<bool> signal_icu_irq2("signal_icu_irq2");
	sc_signal<bool> signal_icu_irq3("signal_icu_irq3");
	sc_signal<bool> signal_icu_irq4("signal_icu_irq4");
	sc_signal<bool> signal_icu_irq5("signal_icu_irq5");
	sc_signal<bool> signal_icu_irq6("signal_icu_irq6");

	soclib::common::Loader loader("mutekh/kernel-soclib-mips.out");

        //                                  init_rw   init_c   tgt
	soclib::caba::VciCcXCacheWrapperV1<vci_param, proc_iss > 
	proc0("proc0", 0, maptabp, maptabc, IntTab(0),IntTab(0),IntTab(0),4,64,16,4,64,16);

	soclib::caba::VciCcXCacheWrapperV1<vci_param, proc_iss > 
	proc1("proc1", 1, maptabp, maptabc, IntTab(1),IntTab(1),IntTab(1),4,64,16,4,64,16);

	soclib::caba::VciCcXCacheWrapperV1<vci_param, proc_iss > 
	proc2("proc2", 2, maptabp, maptabc, IntTab(2),IntTab(2),IntTab(2),4,64,16,4,64,16);

	soclib::caba::VciCcXCacheWrapperV1<vci_param, proc_iss > 
	proc3("proc3", 3, maptabp, maptabc, IntTab(3),IntTab(3),IntTab(3),4,64,16,4,64,16);

	soclib::caba::VciSimpleRam<vci_param> 
	rom("rom", IntTab(0), maptabp, loader);

	soclib::caba::VciSimpleRam<vci_param> 
	xram("xram", IntTab(0), maptabx, loader);

        //                                  x_init    c_init    p_tgt     c_tgt
	//soclib::caba::VciMemCacheV3<vci_param> 
	//memc("memc",maptabp,maptabc,maptabx,IntTab(0),IntTab(4),IntTab(1), IntTab(4),16,256,16,1024);
	//memc("memc",maptabp,maptabc,maptabx,IntTab(0),IntTab(4),IntTab(1), IntTab(4),4,16,16,32);
	soclib::caba::VciMemCacheV2<vci_param> 
	memc("memc",maptabp,maptabc,maptabx,IntTab(0),IntTab(4),IntTab(1), IntTab(4),16,256,16);
       

	soclib::caba::VciMultiTty<vci_param> vcitty("vcitty",	IntTab(2), maptabp, "vcitty", NULL);
        soclib::caba::VciXicu<vci_param> vcixicu("vcixicu", maptabp, IntTab(3), 4, 1, 4, 4);
	

#ifdef VCI_LOGGER_ON_L1
  soclib::caba::VciLogger<vci_param> vci_logger0("vci_logger0",maptabp);
#endif

#ifdef VCI_LOGGER_ON_ROM
  soclib::caba::VciLogger<vci_param> vci_logger1("vci_logger1",maptabp);
#endif
#ifdef VCI_LOGGER_ON_DMA
  soclib::caba::VciLogger<vci_param> vci_logger2("vci_logger2",maptabp);
#endif

#ifdef USE_VGMN
	soclib::caba::VciVgmn<vci_param> 
	ringp("ringp",maptabp, 4, 4, 2, 8);

	soclib::caba::VciVgmn<vci_param> 
	ringc("ringc",maptabc, 5, 5, 2, 8);

#else
	soclib::caba::VciSimpleRingFast<vci_param, 40, 33> 
	ringp("ringp",maptabp, IntTab(), 2, 4, 4);

	soclib::caba::VciSimpleRingFast<vci_param, 40, 33> 
	ringc("ringc",maptabc, IntTab(), 2, 5, 5);

#endif

	proc0.p_clk(signal_clk);  
	proc0.p_resetn(signal_resetn);  
	proc0.p_irq[0](signal_proc0_it0); 
	proc0.p_irq[1](signal_proc0_it1); 
	proc0.p_irq[2](signal_proc0_it2); 
	proc0.p_irq[3](signal_proc0_it3); 
	proc0.p_irq[4](signal_proc0_it4); 
	proc0.p_irq[5](signal_proc0_it5); 
	proc0.p_vci_ini_rw(signal_vci_ini_rw_proc0);
	proc0.p_vci_ini_c(signal_vci_ini_c_proc0);
	proc0.p_vci_tgt(signal_vci_tgt_proc0);


	proc1.p_clk(signal_clk);  
	proc1.p_resetn(signal_resetn);  
	proc1.p_irq[0](signal_proc1_it0); 
	proc1.p_irq[1](signal_proc1_it1); 
	proc1.p_irq[2](signal_proc1_it2); 
	proc1.p_irq[3](signal_proc1_it3); 
	proc1.p_irq[4](signal_proc1_it4); 
	proc1.p_irq[5](signal_proc1_it5); 
	proc1.p_vci_ini_rw(signal_vci_ini_rw_proc1);
	proc1.p_vci_ini_c(signal_vci_ini_c_proc1);
	proc1.p_vci_tgt(signal_vci_tgt_proc1);

	proc2.p_clk(signal_clk);  
	proc2.p_resetn(signal_resetn);  
	proc2.p_irq[0](signal_proc2_it0); 
	proc2.p_irq[1](signal_proc2_it1); 
	proc2.p_irq[2](signal_proc2_it2); 
	proc2.p_irq[3](signal_proc2_it3); 
	proc2.p_irq[4](signal_proc2_it4); 
	proc2.p_irq[5](signal_proc2_it5); 
	proc2.p_vci_ini_rw(signal_vci_ini_rw_proc2);
	proc2.p_vci_ini_c(signal_vci_ini_c_proc2);
	proc2.p_vci_tgt(signal_vci_tgt_proc2);

	proc3.p_clk(signal_clk);  
	proc3.p_resetn(signal_resetn);  
	proc3.p_irq[0](signal_proc3_it0); 
	proc3.p_irq[1](signal_proc3_it1); 
	proc3.p_irq[2](signal_proc3_it2); 
	proc3.p_irq[3](signal_proc3_it3); 
	proc3.p_irq[4](signal_proc3_it4); 
	proc3.p_irq[5](signal_proc3_it5); 
	proc3.p_vci_ini_rw(signal_vci_ini_rw_proc3);
	proc3.p_vci_ini_c(signal_vci_ini_c_proc3);
	proc3.p_vci_tgt(signal_vci_tgt_proc3);

	rom.p_clk(signal_clk);
	rom.p_resetn(signal_resetn);
	rom.p_vci(signal_vci_tgt_rom);


	vcixicu.p_clk(signal_clk);
	vcixicu.p_vci(signal_vci_icu);
	vcixicu.p_hwi[0](signal_icu_irq0);
	vcixicu.p_irq[0](signal_proc0_it0);
	vcixicu.p_irq[1](signal_proc1_it0);
	vcixicu.p_irq[2](signal_proc2_it0);
	vcixicu.p_irq[3](signal_proc3_it0);
	vcixicu.p_resetn(signal_resetn);


#ifdef VCI_LOGGER_ON_L1
  vci_logger0.p_clk(signal_clk);
  vci_logger0.p_resetn(signal_resetn);
  vci_logger0.p_vci(signal_vci_ini_rw_proc0);
#endif

#ifdef VCI_LOGGER_ON_ROM
  vci_logger1.p_clk(signal_clk);
  vci_logger1.p_resetn(signal_resetn);
  vci_logger1.p_vci(signal_vci_tgt_rom);
#endif

	vcitty.p_clk(signal_clk);
	vcitty.p_resetn(signal_resetn);
	vcitty.p_vci(signal_vci_tty);
	vcitty.p_irq[0](signal_icu_irq0); 
	

	memc.p_clk(signal_clk);
	memc.p_resetn(signal_resetn);
	memc.p_vci_tgt(signal_vci_tgt_memc);
	memc.p_vci_tgt_cleanup(signal_vci_tgt_cleanup_memc);
	memc.p_vci_ini(signal_vci_ini_memc);
	memc.p_vci_ixr(signal_vci_tgt_xram);

	xram.p_clk(signal_clk);
	xram.p_resetn(signal_resetn);
	xram.p_vci(signal_vci_tgt_xram);
	
	ringp.p_clk(signal_clk);
	ringp.p_resetn(signal_resetn);

	ringc.p_clk(signal_clk);
	ringc.p_resetn(signal_resetn);


	ringp.p_to_initiator[0](signal_vci_ini_rw_proc0);
	ringp.p_to_initiator[1](signal_vci_ini_rw_proc1);
	ringp.p_to_initiator[2](signal_vci_ini_rw_proc2);
	ringp.p_to_initiator[3](signal_vci_ini_rw_proc3);

	ringc.p_to_initiator[4](signal_vci_ini_memc);
	ringc.p_to_initiator[0](signal_vci_ini_c_proc0);
	ringc.p_to_initiator[1](signal_vci_ini_c_proc1);
	ringc.p_to_initiator[2](signal_vci_ini_c_proc2);
	ringc.p_to_initiator[3](signal_vci_ini_c_proc3);

	ringp.p_to_target[0](signal_vci_tgt_rom);
	ringp.p_to_target[1](signal_vci_tgt_memc);
	ringp.p_to_target[2](signal_vci_tty);
	ringp.p_to_target[3](signal_vci_icu);
	
	ringc.p_to_target[0](signal_vci_tgt_proc0);
	ringc.p_to_target[1](signal_vci_tgt_proc1);
	ringc.p_to_target[2](signal_vci_tgt_proc2);
	ringc.p_to_target[3](signal_vci_tgt_proc3);
	ringc.p_to_target[4](signal_vci_tgt_cleanup_memc);


	int ncycles;

	sc_start(sc_core::sc_time(0, SC_NS));
	signal_resetn = false;

	sc_start(sc_core::sc_time(1, SC_NS));
	signal_resetn = true;

	while(1)
	{
	  sc_start(sc_core::sc_time(CYCLES, SC_NS));
	}

        std::cout << "Hit ENTER to end simulation" << std::endl;
        char buf[1];

	std::cin.getline(buf,1);

	return EXIT_SUCCESS;
}

int sc_main (int argc, char *argv[])
{
	try {
		return _main(argc, argv);
	} catch (std::exception &e) {
		std::cout << e.what() << std::endl;
	} catch (...) {
		std::cout << "Unknown exception occured" << std::endl;
		throw;
	}
	return 1;
}
