/**
 * \file    : exceptions.c
 * \date    : December 2012
 * \author  : Manuel Bouyer
 *
 * This file defines a simple exeptions handler
 */

#include <boot_tty.h>

#define in_reset       __attribute__((section (".reset")))
#define in_reset_data __attribute__((section (".reset_data")))

in_reset void handle_exept(int status, int cause, int epc)
{
	boot_puts("boot (default) exeption handler called: \r\n    status ");
	boot_putx(status);
	boot_puts("\r\n    cause  ");
	boot_putx(cause);
	boot_puts(" (exeption ");
	boot_putx((cause >> 2) & 0x1f);
	boot_puts(")\r\n    epc    ");
	boot_putx(epc);
	boot_puts("\r\n");
	while (1);
}
