/**
 * \file    : boot_utils.h
 * \date    : August 2012
 * \author  : Cesar Fuguet
 *
 * Definition of some miscellaneous functions used by the
 * pre-loader
 */

#ifndef BOOT_UTILS_H
#define BOOT_UTILS_H

#include <elf-types.h>
#include <boot_tty.h>

/**
 * memcpy( _dst, _src, size )
 *
 * Transfer data between to memory buffers.
 *
 * \param _dst   : Destination buffer base address 
 * \param _src   : Source buffer base address
 * \param size   : Number of bytes to transfer 
 *
 */
void * memcpy(void *_dst, const void *_src, unsigned int size);

/**
 * memset( _dst, value, size )
 *
 * Initialize memory buffers with predefined value.
 *
 * \param _dst   : Destination buffer base address 
 * \param value  : Initialization value 
 * \param size   : Number of bytes to initialize
 *
 */
void * memset(void *_dst, const int value, unsigned int size);

/******************************************************************************
 * Misc functions for the ELF 
 *****************************************************************************/

/**
 * boot_print_elf_phdr( elf_phdr_ptr )
 *
 * Print some fields of a ELF program header
 *
 * \param elf_phdr_ptr : Pointer to the ELF program header to print
 *
 */
void boot_print_elf_phdr(Elf32_Phdr * elf_phdr_ptr);

#endif

// vim: tabstop=4 : softtabstop=4 : shiftwidth=4 : expandtab

