#ifndef RESET_IOC_H
#define RESET_IOC_H

#ifndef SOCLIB_IOC
#include <sdcard.h>
#include <spi.h>
#else
#include <block_device.h>
#include <mcc.h>
#endif

#include <defs.h>
#include <reset_tty.h>
#include <io.h>

extern int reset_ioc_init();

extern int reset_ioc_read( unsigned int lba, 
                           void*        buffer, 
                           unsigned int count );

extern int reset_ioc_completed();

extern void reset_buf_invalidate ( const void * buffer,
                                   unsigned int line_size,
                                   unsigned int size );

extern void reset_mcc_invalidate( const void * buffer,
                                  unsigned int size );
#endif

/*
 * vim: tabstop=4 : shiftwidth=4 : expandtab
 */
