/*
 * \file    : reset_utils.h
 * \date    : August 2012
 * \author  : Cesar Fuguet
 */

#ifndef BOOT_UTILS_H
#define BOOT_UTILS_H

#include <elf-types.h>
#include <reset_tty.h>

extern unsigned int proctime();

extern void* memcpy(void *_dst, const void *_src, unsigned int size);

extern void* memset(void *_dst, const int value, unsigned int size);

extern void reset_print_elf_phdr(Elf32_Phdr * elf_phdr_ptr);

#if USE_IOB
void reset_mcc_invalidate ( const void * buffer,
                            unsigned int size);
#endif /* USE_IOB */

#if (CACHE_COHERENCE == 0) || USE_IOB
void reset_buf_invalidate ( const void * buffer,
                            unsigned int line_size,
                            unsigned int size);
#endif /* (CACHE_COHERENCE == 0) || USE_IOB */
#endif /* BOOT_UTILS_H */

// vim: tabstop=4 : softtabstop=4 : shiftwidth=4 : expandtab

