#!/bin/sh

n="tsarboot"
v=$(cat version)
t=$(date)
u=${USER-root}
h=$(hostname)

reporev=$(svn info 2>/dev/null)
if [ $? -eq 0 ]
then
    repotype="svn"
    reporev=$(echo $reporev | awk -F: '$1 == "Last Changed Rev" {print $2}')
else
    repotype="git"
    reporev=$(git rev-parse HEAD)
fi

printf "%s" \
   "const char versionstr[]=\"$n $v ($u@$h $t) ($repotype revision $reporev)\n\r\";"
