/* -*- c++ -*-
 * File 	: vci_traffic_generator.cpp
 * Date 	: 26/08/2010
 * Copyright 	: UPMC / LIP6
 * Authors 	: Christophe Choichillon
 *
 * SOCLIB_LGPL_HEADER_BEGIN
 *
 * This file is part of SoCLib, GNU LGPLv2.1.
 *
 * SoCLib is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; version 2.1 of the License.
 *
 * SoCLib is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with SoCLib; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 * SOCLIB_LGPL_HEADER_END
 *
 * Maintainers: christophe.choichillon@lip6.fr
 */

#include "../include/vci_synthetic_initiator.h"



namespace soclib { namespace caba {


#define tmpl(x) template<typename vci_param> x VciSyntheticInitiator<vci_param>

  //using soclib::common::uint32_log2;	
  
  ////////////////////////////////
  // 	Constructor 
  ////////////////////////////////

  tmpl(/**/)::VciSyntheticInitiator( 
      sc_module_name name,
      size_t length,    // Packet length (flit numbers)
      float  rho,       // Packets ratio on the network
      size_t depth,     // Fifo depth
      size_t x,		// 
      size_t y,		//
      size_t xmesh,	
      size_t ymesh,
      size_t bc_period, // Broadcast period, if no broadcast => 0
      size_t xmin, 
      size_t xmax,
      size_t ymin,
      size_t ymax
      )

    : soclib::caba::BaseModule(name),

    p_clk("clk"),
    p_resetn("resetn"),
    p_vci("vci_ini"),

    m_srcid_ini( mtc.indexForId(vci_ini_index) ),
    //  FIFOs 
    m_length(length),
    m_rho(rho),
    m_depth(depth),
    m_x(x),
    m_y(y),
    m_xmesh(xmesh),
    m_ymesh(ymesh),
    m_bc_period(bc_period),
    m_xmin(xmin),
    m_xmax(xmax),
    m_ymin(ymin),
    m_ymax(ymax),
    m_date_fifo("m_date_fifo", depth),
    r_tgt_cmd_fsm("r_tgt_cmd_fsm"),
    {


      SC_METHOD(transition);
      dont_initialize();
      sensitive << p_clk.pos();

      SC_METHOD(genMoore);
      dont_initialize();
      sensitive << p_clk.neg();

    } // end constructor


  /////////////////////////////////
  tmpl(/**/)::~VciSyntheticInitiator()
    /////////////////////////////////
  {
  }

  ///////////////////////////////////
  tmpl(void)::destAdress(size_t X_local, size_t Y_local, size_t &X_dest, size_t &Y_dest)
  ///////////////////////////////////
  {
    X_dest = (size_t) ((rand())%m_xmesh);
    Y_dest = (size_t) ((rand())%m_ymesh);
  }

  //////////////////////////////////
  tmpl(void)::transition()
    //////////////////////////////////
  {
    //using soclib::common::uint32_log2;
    //  RESET          
    if ( ! p_resetn.read() ) {
      //srand(time(NULL));
      //     Initializing FSMs
      r_tgt_cmd_fsm 	= TGT_CMD_IDLE;

      // initializing FIFOs and communication Buffers

      m_date_fifo.init();

      // Activity counters
      m_cpt_cycles		= 0;
      m_npackets		= 0;

      return;
    }

    bool    date_fifo_put = false;
    bool    date_fifo_get = false;

    switch ( r_vci_fsm.read() ) {

      //////////////////
      case VCI_IDLE:
        {
          break;
        }
        //////////////////
      case VCI_SINGLE_SEND:
        {
          break;
        }
        //////////////////////
      case VCI_SINGLE_RECEIVE:
        {
	  if (p_vci.cmdack.read()) {
	    // LATENCY
	    r_vci_fsm = VCI_IDLE ;
	  }
          break;
        }
        ///////////////////
      case VCI_BC_SEND:
        {
          break;
        }
        ////////////////////
      case VCI_BC_RECEIVE:
        {
	  r_broadcast_req = false;
          break;
        }
    } // end switch vci_fsm


/////////////////// Filling fifo
    if(){
      if (m_date_fifo.wok()){
        date_fifo_put = true ;
      } 
      if (!r_broadcast_req.read() && (m_cpt_cycles % bc_period)){
        r_broadcast_req = true;
      }
    }

    if (date_fifo_put){
      if (date_fifo_get){
        m_date_fifo.put_and_get(m_cpt_cycles);
      } else {
        m_date_fifo.simple_put(m_cpt_cycles);
      }
    } else {
      if (date_fifo_get){
        m_date_fifo.simple_get();
      }
    }


    m_cpt_cycles++;

    return;

  } // end transition()

  /////////////////////////////
  tmpl(void)::genMoore()
    /////////////////////////////
  {
    ////////////////////////////////////////////////////////////
    // Command signals on the p_vci_ixr port
    ////////////////////////////////////////////////////////////
     p_vci.cmd        = vci_param::CMD_READ;   
     p_vci.be         = 0xF;                             
     p_vci.pktid      = 0;      
     p_vci.srcid      = m_srcid_ixr;   
     p_vci.cons       = false;        
     p_vci.wrap       = false;       
     p_vci.contig     = true;       
     p_vci.clen       = 0;         
     p_vci.cfixed     = false;           


    switch ( r_vci_fsm.read() ) {

      //////////////////
      case VCI_IDLE:
        {
	  p_vci.cmdval  = false;                 
	  p_vci.address = 0; 
	  p_vci.plen    = 0;                                         
	  p_vci.wdata   = 0;                                       
	  p_vci.trdid   = 0;                  
	  p_vci.eop     = false;                                   
          break;
        }
        //////////////////
      case VCI_SINGLE_SEND:
        {
	  p_vci.cmdval = true ;
          break;
        }
        //////////////////////
      case VCI_SINGLE_RECEIVE:
        {
          break;
        }
        ///////////////////
      case VCI_BC_SEND:
        {
          break;
        }
        ////////////////////
      case VCI_BC_RECEIVE:
        {
          break;
        }
    } // end switch vci_fsm

  } // end genMoore()

}} // end name space
