/**
 * \file   reset_sdc.h
 * \author Cesar Fuguet
 * \date   July 23, 2014
 *
 * \brief  Wrapper for the SD card and SPI drivers
 */
#ifndef RESET_SDC_H
#define RESET_SDC_H

/**
 * \brief this function initializes the SD card device and the SPI controller
 */
int reset_sdc_init();

/**
 * \brief read a block in the SD card device using the SPI controller
 */
int reset_sdc_read( unsigned int lba, void* buffer, unsigned int count );

#endif /* RESET_SDCARD_H */

/*
 * vim: tabstop=4 : softtabstop=4 : shiftwidth=4 : expandtab
 */
