

exec(file("hard_params.py"))


def hard_config(x, y, x_width, y_width, p, hard_config, protocol):

    x_io = get_x_io(x_width, y_width)
    y_io = get_y_io(x_width, y_width)
    
    seg_rom_base = BOOT_ADDR
    seg_rom_size = ROM_SIZE

    seg_ram_base = RAM_BASE
    seg_ram_size = ram_size(x_width, y_width)

    seg_xcu_base = replicated_periph_base_addr(x_width, y_width, XCU_TGTID)
    seg_xcu_size = XCU_SIZE

    seg_dma_base = replicated_periph_base_addr(x_width, y_width, DMA_TGTID)
    seg_dma_size = DMA_SIZE * NB_DMA_CHANNELS

    seg_ioc_base = periph_addr(x_width, y_width, IOC_TGTID);
    seg_ioc_size = IOC_SIZE

    seg_tty_base = periph_addr(x_width, y_width, TTY_TGTID)
    seg_tty_size = TTY_SIZE

    seg_fbf_base = periph_addr(x_width, y_width, FBF_TGTID)
    seg_fbf_size = FBF_X_SIZE * FBF_Y_SIZE * 2

    seg_nic_base = periph_addr(x_width, y_width, NIC_TGTID)
    seg_nic_size = NIC_SIZE

    seg_cma_base = periph_addr(x_width, y_width, CMA_TGTID)
    seg_cma_size = CMA_SIZE * NB_CMA_CHANNELS

    seg_sim_base = periph_addr(x_width, y_width, SIM_TGTID)
    seg_sim_size = SIM_SIZE

    header = '''
#ifndef _HARD_CONFIG_H_
#define _HARD_CONFIG_H_

/* Generated from gen_hard_config.py */

/* General platform parameters */

#define X_SIZE                 %(x_size)d
#define Y_SIZE                 %(y_size)d
#define X_WIDTH                %(x_width)d
#define Y_WIDTH                %(y_width)d
#define P_WIDTH                4
#define X_IO                   %(x_io)d
#define Y_IO                   %(y_io)d
#define NB_PROCS_MAX           %(proc_per_clus)d
#define IRQ_PER_PROCESSOR      4
#define RESET_ADDRESS          0x%(seg_rom_base)x


/* Peripherals */

#define RAM_TGTID              %(ram_tgtid)d
#define XCU_TGTID              %(xcu_tgtid)d
#define DMA_TGTID              %(dma_tgtid)d
#define TTY_TGTID              %(tty_tgtid)d
#define IOC_TGTID              %(ioc_tgtid)d
#define NIC_TGTID              %(nic_tgtid)d
#define ROM_TGTID              %(rom_tgtid)d
#define CMA_TGTID              %(cma_tgtid)d
#define SIM_TGTID              %(sim_tgtid)d
#define FBF_TGTID              %(fbf_tgtid)d

#define NB_TTY_CHANNELS        %(nb_tty_channels)d
#define NB_IOC_CHANNELS        %(nb_ioc_channels)d
#define NB_NIC_CHANNELS        0
#define NB_CMA_CHANNELS        %(nb_cma_channels)d
#define NB_TIM_CHANNELS        0
#define NB_DMA_CHANNELS        %(nb_dma_channels)d

#define USE_XCU                1
#define USE_IOB                0
#define USE_PIC                0
#define USE_FBF                1

#define USE_IOC_BDV            1
#define USE_IOC_SDC            0
#define USE_IOC_HBA            0
#define USE_IOC_RDK            0

#define FBF_X_SIZE             %(fbf_x_size)d
#define FBF_Y_SIZE             %(fbf_y_size)d


/* base addresses and sizes for physical segments */

#define SEG_RAM_BASE           0x%(seg_ram_base)x
#define SEG_RAM_SIZE           0x%(seg_ram_size)x

#define SEG_CMA_BASE           0x0 // Component requires a multiple of 4K
#define SEG_CMA_SIZE           0x0

#define SEG_DMA_BASE           0x%(seg_dma_base)x
#define SEG_DMA_SIZE           0x%(seg_dma_size)x

#define SEG_FBF_BASE           0x%(seg_fbf_base)x
#define SEG_FBF_SIZE           0x%(seg_fbf_size)x

#define SEG_ICU_BASE           0xffffffff
#define SEG_ICU_SIZE           0x0

#define SEG_IOB_BASE           0xffffffff
#define SEG_IOB_SIZE           0x0

#define SEG_IOC_BASE           0x%(seg_ioc_base)x
#define SEG_IOC_SIZE           0x%(seg_ioc_size)x

#define SEG_MMC_BASE           0xffffffff
#define SEG_MMC_SIZE           0x0

#define SEG_MWR_BASE           0xffffffff
#define SEG_MWR_SIZE           0x0

#define SEG_ROM_BASE           0x%(seg_rom_base)x
#define SEG_ROM_SIZE           0x%(seg_rom_size)x

#define SEG_SIM_BASE           0x%(seg_sim_base)x
#define SEG_SIM_SIZE           0x%(seg_sim_size)x

#define SEG_NIC_BASE           0x%(seg_nic_base)x
#define SEG_NIC_SIZE           0x%(seg_nic_size)x

#define SEG_PIC_BASE           0xffffffff
#define SEG_PIC_SIZE           0x0

#define SEG_TIM_BASE           0xffffffff
#define SEG_TIM_SIZE           0x0

#define SEG_TTY_BASE           0x%(seg_tty_base)x
#define SEG_TTY_SIZE           0x%(seg_tty_size)x

#define SEG_XCU_BASE           0x%(seg_xcu_base)x
#define SEG_XCU_SIZE           0x%(seg_xcu_size)x

#define SEG_RDK_BASE           0xffffffff
#define SEG_RDK_SIZE           0x0

''' % dict(x_size = x, y_size = y, x_width = x_width, y_width = y_width,
        x_io = x_io,
        y_io = y_io,
        proc_per_clus = p,
        nb_tty_channels = NB_TTY_CHANNELS,
        nb_ioc_channels = NB_IOC_CHANNELS,
        nb_cma_channels = NB_CMA_CHANNELS,
        nb_dma_channels = NB_DMA_CHANNELS,
        fbf_x_size = FBF_X_SIZE, fbf_y_size = FBF_Y_SIZE,
        ram_tgtid = RAM_TGTID,
        xcu_tgtid = XCU_TGTID,
        dma_tgtid = DMA_TGTID,
        tty_tgtid = TTY_TGTID,
        ioc_tgtid = IOC_TGTID,
        nic_tgtid = NIC_TGTID,
        rom_tgtid = ROM_TGTID,
        cma_tgtid = CMA_TGTID,
        sim_tgtid = SIM_TGTID,
        fbf_tgtid = FBF_TGTID,
        seg_ram_base = seg_ram_base,
        seg_ram_size = seg_ram_size,
        seg_dma_base = seg_dma_base,
        seg_dma_size = seg_dma_size,
        seg_fbf_base = seg_fbf_base,
        seg_fbf_size = seg_fbf_size,
        seg_ioc_base = seg_ioc_base,
        seg_ioc_size = seg_ioc_size,
        seg_rom_base = seg_rom_base,
        seg_rom_size = seg_rom_size,
        seg_sim_base = seg_sim_base,
        seg_sim_size = seg_sim_size,
        seg_nic_base = seg_nic_base,
        seg_nic_size = seg_nic_size,
        seg_tty_base = seg_tty_base,
        seg_tty_size = seg_tty_size,
        seg_xcu_base = seg_xcu_base,
        seg_xcu_size = seg_xcu_size)

    if protocol == 'wtidl':
        header += '#define WT_IDL\n'

    header += '#endif //_HD_CONFIG_H\n'

    file = open(hard_config, 'w')
    file.write(header)
    file.close()


if __name__ == "__main__":
    if len(sys.argv) != 6:
        print "Usage: %s <x> <y> <p> <hard_config-filename> <protocol>" % argv[0]
        print "with:"
        print "<x>: number of clusters in X"
        print "<y>: number of clusters in Y"
        print "<p>: number of processors per clusters"
        sys.exit(0)

    x = argv[1]
    y = argv[2]
    p = argv[3]
    hard_config_filename = argv[4]
    protocol = argv[5]

    hard_config(x, y, p, hard_config_filename, protocol)


