
RAM_TGTID = 0
XCU_TGTID = 1
DMA_TGTID = 2
TTY_TGTID = 3
IOC_TGTID = 4
NIC_TGTID = 5
ROM_TGTID = 6
CMA_TGTID = 7
SIM_TGTID = 8
FBF_TGTID = 9

DMA_SIZE = 0X00001000
XCU_SIZE = 0X00001000
TTY_SIZE = 0X00001000
IOC_SIZE = 0X00001000
NIC_SIZE = 0x00080000
ROM_SIZE = 0x00100000
CMA_SIZE = 0x00004000
SIM_SIZE = 0X00001000
FBF_SIZE = 0X00200000

RAM_BASE = 0x0
RAM_MAX_TOTAL_SIZE = 0x10000000
RAM_MAX_CLUST_SIZE = 0x10000000


NB_DMA_CHANNELS = 1
NB_CMA_CHANNELS = 0
NB_TTY_CHANNELS = 4
NB_IOC_CHANNELS = 1
TTY_CHANNEL_SIZE = 0X00000010

FBF_X_SIZE = 1024
FBF_Y_SIZE = 1024


P_WIDTH = 4

ADDR_WIDTH = 32
BOOT_ADDR = 0xbfc00000

OUTPUT_IRQ_PER_PROC = 4


def get_x_io(x_width, y_width):
    return BOOT_ADDR >> (ADDR_WIDTH - x_width)

def get_y_io(x_width, y_width):
    return (BOOT_ADDR >> (ADDR_WIDTH - x_width - y_width)) & ((1 << y_width) - 1)


def replicated_periph_base_addr(x_width, y_width, tgtid):
    demi_cluster_inc = (1 << (ADDR_WIDTH - 1)) >> (x_width + y_width)
    return demi_cluster_inc + (tgtid << 19)

def replicated_periph_addr(x, y, x_width, y_width, base_addr):
    cid = x * (1 << y_width) + y
    demi_cluster_inc = (1 << (ADDR_WIDTH - 1)) >> (x_width + y_width)
    return demi_cluster_inc * 2 * cid + base_addr



def periph_addr(x_width, y_width, tgtid):
    demi_cluster_inc = (1 << (ADDR_WIDTH - 1)) >> (x_width + y_width)

    x_io = get_x_io(x_width, y_width)
    y_io = get_y_io(x_width, y_width)
    cluster_io_id = x_io * (1 << y_width) + y_io
    cluster_io_offset = cluster_io_id * demi_cluster_inc * 2
    return demi_cluster_inc + cluster_io_offset + (tgtid << 19)


def ram_size(x_width, y_width):
    return min(RAM_MAX_TOTAL_SIZE >> (x_width + y_width), RAM_MAX_CLUST_SIZE) 


def ram_addr(x, y, x_width, y_width):
    cid = x * (1 << y_width) + y
    demi_cluster_inc = (1 << (ADDR_WIDTH - 1)) >> (x_width + y_width)
    return demi_cluster_inc * 2 * cid + RAM_BASE

