/* -*- c++ -*-
 * File         : vci_synthetic_initiator.h
 * Date         : 26/08/2010
 * Copyright    : UPMC / LIP6
 * Authors      : Christophe Choichillon
 *
 * SOCLIB_LGPL_HEADER_BEGIN
 *
 * This file is part of SoCLib, GNU LGPLv2.1.
 *
 * SoCLib is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; version 2.1 of the License.
 *
 * SoCLib is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with SoCLib; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 * SOCLIB_LGPL_HEADER_END
 *
 * Maintainers: christophe.choichillon@lip6.fr
 */

#ifndef SOCLIB_CABA_SYNTHETIC_INITIATOR_H
#define SOCLIB_CABA_SYNTHETIC_INITIATOR_H

#include <systemc>

namespace soclib {  namespace caba {
    using namespace sc_core;

    template<typename vci_param>
    class VciSyntheticInitiator
      : public soclib::caba::BaseModule
    {
      typedef uint32_t addr_t;
      typedef uint32_t data_t;
      typedef uint32_t tag_t;
      typedef uint32_t size_t;
      typedef uint32_t be_t;
      typedef uint32_t copy_t;


      /* States of the GENERATOR fsm */
      enum vci_fsm_state_e{
	VCI_IDLE,
	VCI_SINGLE_SEND,
	VCI_SINGLE_RECEIVE,
	VCI_BC_SEND,
	VCI_BC_RECEIVE
      };
      enum gen_fsm_state_e{
	A_IDLE,
	A_DATA
      };

      uint32_t	   m_cpt_cycles;            // Counter of cycles 

    protected:

      SC_HAS_PROCESS(VciSyntheticInitiator);
    
    public:
      sc_in<bool> 			  	p_clk;
      sc_in<bool> 			  	p_resetn;
      soclib::caba::VciInitiator<vci_param> 	p_vci;	

      VciSyntheticInitiator(
		  sc_module_name name,                            // Instance Name 
		  const soclib::common::MappingTable &mtp,        // Mapping table for primary requets
		  const soclib::common::IntTab &vci_index,  	  // VCI port to PROC (initiator)
		  size_t nways,                                   // Number of ways per set 
		  size_t nsets,                                   // Number of sets
		  size_t nwords);                                 // Number of words per line

      ~VciSyntheticInitiator();

      void transition();

      void genMoore();

      void print_stats();

    private:

      // Component attributes
      const size_t   			  m_initiators;		// Number of initiators
      const size_t			  m_ways;		// Number of ways in a set
      const size_t			  m_sets;		// Number of cache sets
      const size_t			  m_words;		// Number of words in a line
      const size_t  		  	  m_srcid;		// Srcid for requests to processors

      data_t	        	          ***m_cache_data;	// data array[set][way][word]

      // adress masks
      const soclib::common::AddressMaskingTable<addr_t>   m_x;
      const soclib::common::AddressMaskingTable<addr_t>   m_y;
      const soclib::common::AddressMaskingTable<addr_t>   m_z;
      const soclib::common::AddressMaskingTable<addr_t>	m_nline; 

      //////////////////////////////////////////////////
      // Registers controlled by the TGT_CMD fsm
      //////////////////////////////////////////////////

      // Fifo between TGT_CMD fsm and READ fsm
      GenericFifo<addr_t>    m_cmd_read_addr_fifo;

      sc_signal<int>         r_vci_fsm;
	
      sc_signal<size_t>	     r_index;

    }; // end class VciMemCache
 
  }}

#endif
