/* -*- c++ -*-
 * File 	: vci_traffic_generator.cpp
 * Date 	: 26/08/2010
 * Copyright 	: UPMC / LIP6
 * Authors 	: Christophe Choichillon
 *
 * SOCLIB_LGPL_HEADER_BEGIN
 *
 * This file is part of SoCLib, GNU LGPLv2.1.
 *
 * SoCLib is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; version 2.1 of the License.
 *
 * SoCLib is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with SoCLib; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 * SOCLIB_LGPL_HEADER_END
 *
 * Maintainers: christophe.choichillon@lip6.fr
 */

#include "../include/vci_synthetic_initiator.h"



namespace soclib { namespace caba {


#define tmpl(x) template<typename vci_param> x VciSyntheticInitiator<vci_param>

  //using soclib::common::uint32_log2;	
  
  ////////////////////////////////
  // 	Constructor 
  ////////////////////////////////

  tmpl(/**/)::VciSyntheticInitiator( 
      sc_module_name name,
      size_t length,    // Packet length (flit numbers)
      float  rho,       // Packets ratio on the network
      size_t depth,     // Fifo depth
      size_t x,		// 
      size_t y,		//
      size_t xmesh,	
      size_t ymesh,
      size_t bc_period, // Broadcast period, if no broadcast => 0
      size_t xmin, 
      size_t xmax,
      size_t ymin,
      size_t ymax
      )

    : soclib::caba::BaseModule(name),

    p_clk("clk"),
    p_resetn("resetn"),
    p_vci("vci_ini"),

    m_srcid_ini( mtc.indexForId(vci_ini_index) ),
    //  FIFOs 
    m_date_fifo("m_date_fifo", depth),

    r_tgt_cmd_fsm("r_tgt_cmd_fsm"),
    {

      // Memory cache allocation & initialisation
      m_cache_data = new data_t**[nways];
      for ( size_t i=0 ; i<nways ; ++i ) {
        m_cache_data[i] = new data_t*[nsets];
      }
      for ( size_t i=0; i<nways; ++i ) {
        for ( size_t j=0; j<nsets; ++j ) {
          m_cache_data[i][j] = new data_t[nwords];
          for ( size_t k=0; k<nwords; k++){
            m_cache_data[i][j][k]=0;
          }	
        }
      }

      SC_METHOD(transition);
      dont_initialize();
      sensitive << p_clk.pos();

      SC_METHOD(genMoore);
      dont_initialize();
      sensitive << p_clk.neg();

    } // end constructor


  /////////////////////////////////
  tmpl(/**/)::~VciSyntheticInitiator()
    /////////////////////////////////
  {
    delete [] r_write_to_init_cmd_data;
  }

  //////////////////////////////////
  tmpl(void)::transition()
    //////////////////////////////////
  {
    //using soclib::common::uint32_log2;
    //  RESET          
    if ( ! p_resetn.read() ) {

      //     Initializing FSMs
      r_tgt_cmd_fsm 	= TGT_CMD_IDLE;

      // initializing FIFOs and communication Buffers

      m_date_fifo.init();

      r_read_to_tgt_rsp_req		= false;
      r_read_to_xram_cmd_req		= false;

      r_write_to_tgt_rsp_req		= false;
      r_write_to_xram_cmd_req		= false;
      r_write_to_init_cmd_req		= false;


      // Activity counters
      m_cpt_cycles		= 0;

      return;
    }

    bool    cmd_read_fifo_put = false;
    bool    cmd_read_fifo_get = false;

    switch ( r_vci_fsm.read() ) {

      //////////////////
      case VCI_IDLE:
        {
          break;
        }
        //////////////////
      case VCI_SINGLE_SEND:
        {
          break;
        }
        //////////////////////
      case VCI_SINGLE_RECEIVE:
        {
          break;
        }
        ///////////////////
      case VCI_BC_SEND:
        {
          break;
        }
        ////////////////////
      case VCI_BC_RECEIVE:
        {
          break;
        }
    } // end switch vci_fsm


    if ( cmd_cleanup_fifo_put ) {
      if ( cmd_cleanup_fifo_get ) {
        m_cmd_cleanup_srcid_fifo.put_and_get(p_vci_tgt.srcid.read());
        m_cmd_cleanup_trdid_fifo.put_and_get(p_vci_tgt.trdid.read());
        m_cmd_cleanup_pktid_fifo.put_and_get(p_vci_tgt.pktid.read());
        m_cmd_cleanup_nline_fifo.put_and_get(p_vci_tgt.wdata.read());
      } else {
        m_cmd_cleanup_srcid_fifo.simple_put(p_vci_tgt.srcid.read());
        m_cmd_cleanup_trdid_fifo.simple_put(p_vci_tgt.trdid.read());
        m_cmd_cleanup_pktid_fifo.simple_put(p_vci_tgt.pktid.read());
        m_cmd_cleanup_nline_fifo.simple_put(p_vci_tgt.wdata.read());
      }
    } else {
      if ( cmd_cleanup_fifo_get ) {
        m_cmd_cleanup_srcid_fifo.simple_get();
        m_cmd_cleanup_trdid_fifo.simple_get();
        m_cmd_cleanup_pktid_fifo.simple_get();
        m_cmd_cleanup_nline_fifo.simple_get();
      }
    }

    m_cpt_cycles++;

  } // end transition()

  /////////////////////////////
  tmpl(void)::genMoore()
    /////////////////////////////
  {
    ////////////////////////////////////////////////////////////
    // Command signals on the p_vci_ixr port
    ////////////////////////////////////////////////////////////


    switch ( r_vci_fsm.read() ) {

      //////////////////
      case VCI_IDLE:
        {
          break;
        }
        //////////////////
      case VCI_SINGLE_SEND:
        {
          break;
        }
        //////////////////////
      case VCI_SINGLE_RECEIVE:
        {
          break;
        }
        ///////////////////
      case VCI_BC_SEND:
        {
          break;
        }
        ////////////////////
      case VCI_BC_RECEIVE:
        {
          break;
        }
    } // end switch vci_fsm

  } // end genMoore()

}} // end name space
