
#include <systemc>
#include <sys/time.h>
#include <iostream>
#include <cstdlib>
#include <cstdarg>

#include "mapping_table.h"
#include "alloc_elems.h"
#include "vci_simple_ram.h"
#include "vci_multi_tty.h"
#include "vci_local_ring_network.h"
#include "vci_simple_ring_network.h"
#include "virtual_dspin_network.h"
#include "vci_synthetic_initiator.h"

// MESH SIZE
#define X_MAX           2
#define Y_MAX           2
#define N_CLUSTERS      X_MAX*Y_MAX
// FLIT_WIDTH
#define WIDTH_CMD	40
#define WIDTH_RSP	33
// Face of each DSPIN Router
#define NORTH		0
#define SOUTH		1
#define EAST		2
#define WEST		3
#define LOCAL		4


int _main(int argc, char *argv[])
{
	using namespace sc_core;
	// Avoid repeating these everywhere
	using soclib::common::IntTab;
	using soclib::common::Segment;

	// Define VCI parameters
	typedef soclib::caba::VciParams<4,8,32,1,1,1,8,4,4,1> vci_param;

	// Mapping table primary network

	soclib::common::MappingTable maptab(32, IntTab(2,10), IntTab(2,3), 0x00C00000);

	maptab.add(Segment("reset", RESET_BASE, RESET_SIZE, IntTab(2,1), true));
	maptab.add(Segment("excep", EXCEP_BASE, EXCEP_SIZE, IntTab(2,1), true));
	maptab.add(Segment("tty"  , TTY_BASE  , TTY_SIZE  , IntTab(3,1), false));

	maptab.add(Segment("mc_r0" , MC0_R_BASE , MC0_R_SIZE , IntTab(0,0), false, true, IntTab(0,0)));
	maptab.add(Segment("mc_m0" , MC0_M_BASE , MC0_M_SIZE , IntTab(0,0), true ));
	maptab.add(Segment("mc_r1" , MC1_R_BASE , MC1_R_SIZE , IntTab(1,0), false, true, IntTab(1,0)));
	maptab.add(Segment("mc_m1" , MC1_M_BASE , MC1_M_SIZE , IntTab(1,0), true ));
	maptab.add(Segment("mc_r2" , MC2_R_BASE , MC2_R_SIZE , IntTab(2,0), false, true, IntTab(2,0)));
	maptab.add(Segment("mc_m2" , MC2_M_BASE , MC2_M_SIZE , IntTab(2,0), true ));
	maptab.add(Segment("mc_r3" , MC3_R_BASE , MC3_R_SIZE , IntTab(3,0), false, true, IntTab(3,0)));
	maptab.add(Segment("mc_m3" , MC3_M_BASE , MC3_M_SIZE , IntTab(3,0), true ));

	std::cout << maptab << std::endl;

	// Signals

	sc_clock	signal_clk("clk");
	sc_signal<bool> signal_resetn("resetn");
   
	soclib::caba::VciSignals<vci_param> * signal_vci_ini_synth = soclib::common::alloc_elems<soclib::caba::VciSignals<vci_param> >("signal_vci_ini_synth", N_CLUSTERS);
	soclib::caba::DspinSignals<WIDTH_CMD> **** dspin_signals_cmd_c0 = soclib::common::alloc_elems<solib::caba::DspinSignals<WIDTH_CMD> >("Dspin_cmd_signals", 2, Y_MAX, X_MAX, 5 );
	soclib::caba::DspinSignals<WIDTH_CMD> **** dspin_signals_cmd_c1 = soclib::common::alloc_elems<solib::caba::DspinSignals<WIDTH_CMD> >("Dspin_cmd_signals", 2, Y_MAX, X_MAX, 5 );

	//soclib::caba::VciSignals<vci_param> * signal_vci_tgt_proc  = soclib::common::alloc_elems<soclib::caba::VciSignals<vci_param> >("signal_vci_tgt_proc",  N_CLUSTERS);

	// N_CLUSTERS ring.
	soclib::caba::VciLocalRingFast<vci_param, WIDTH_CMD, WIDTH_RSP> * local_ring = (soclib::caba::VciLocalRingFast<vci_param, WIDTH_CMD, WIDTH_RSP> *) malloc(sizeof(soclib::caba::VciLocalRingFast<vci_param, WIDTH_CMD, WIDTH_RSP> ) * N_CLUSTERS) ;
	for(int i = 0 ; i < N_CLUSTERS ; i++){                                                            // ringid, fifo, fifo, nb_init, nb_tgt
		new(&local_ring[i]) soclib::caba::VciLocalRingFast<vci_param, WIDTH_CMD, WIDTH_RSP> ("cluster" + i,maptab, IntTab(i), 2, 18, 1, 1)
	}

	// Virtual dspin routers
	soclib::caba::VirtualDspinRouter<WIDTH_CMD> ** routers_cmd = (soclib::caba::VirtualDspinRouter<WIDTH_CMD> **) malloc(sizeof(soclib::caba::VirtualDspinRouter<WIDTH_CMD> *) * Y_MAX);
	soclib::caba::VirtualDspinRouter<WIDTH_RSP> ** routers_rsp = (soclib::caba::VirtualDspinRouter<WIDTH_RSP> **) malloc(sizeof(soclib::caba::VirtualDspinRouter<WIDTH_RSP> *) * Y_MAX);

	for(int i = 0; i < Y_MAX; i++ ){
	  routers_cmd[i] = (soclib::caba::VirtualDspinRouter<WIDTH_CMD> * ) malloc(sizeof(soclib::caba::VirtualDspinRouter<WIDTH_CMD>) * X_MAX);
	  routers_rsp[i] = (soclib::caba::VirtualDspinRouter<WIDTH_RSP> * ) malloc(sizeof(soclib::caba::VirtualDspinRouter<WIDTH_RSP>) * X_MAX);
	  for(int j = 0; j < X_MAX; i++){
	    new(&routers_cmd[i][j]) soclib::caba::VirtualDspinRouter<WIDTH_CMD> ("VDspinRouterCMD" + i + j, j, i, soclib::common::uint32_log2(X_MAX), soclib::common::uint32_log2(Y_MAX), 4, 4);
	    new(&routers_rsp[i][j]) soclib::caba::VirtualDspinRouter<WIDTH_RSP> ("VDspinRouterRSP" + i + j, j, i, soclib::common::uint32_log2(X_MAX), soclib::common::uint32_log2(Y_MAX), 4, 4);
	  }
	}


	///////////////////////////////////////////////////////////////
	// Components
	///////////////////////////////////////////////////////////////

	// N_CLUSTERS VCI Synthetic Initiator (1 initiator per cluster/network)
	soclib::caba::VciSyntheticInitiator<vci_param> * initiator = (soclib::caba::VciSyntheticInitiator<vci_param> *) malloc(sizeof(soclib::caba::VciSyntheticInitiator<vci_param> )* N_CLUSTERS);
	for(int i = 0 ; i < Y_MAX; i++)
		for(int j = 0 ; j < Y_MAX ; j++)
			new(&initiator[Y_MAX*i+j]) soclib::caba::VciSyntheticInitiator<vci_param> ("Initiator" + (Y_MAX*i+j), Y_MAX*i+j, maptab, IntTab(i,j),);

	///////////////////////////////////////////////////////////////
	// Connection of Synthetic Initiator to each local ring per cluster
	///////////////////////////////////////////////////////////////
	for(int i = 0 ; i < N_CLUSTERS ; i++){
	  local_ring[i].p_clk(signal_clk);
	  local_ring[i].p_resetn(signal_resetn);
	  local_ring[i].p_to_initiator[0](signal_vci_ini_synth[i]);
	  initiator[i].p_clk(signal_clk);
	  initiator[i].p_resetn(signal_resetn);
	  initiator[i].p_vci(signal_vci_ini_synth[i]);
	}
	
	///////////////////////////////////////////////////////////////
	// Connection of each VDspin Router to each local ring 
	///////////////////////////////////////////////////////////////
	for(int i = 0; i < Y_MAX ; i++){
	  for(int j = 0; j < X_MAX ; j++){
	    routers_cmd[i][j].p_clk(signal_clk);
	    routers_cmd[i][j].p_resetn(signal_resetn);
	    for(k = 0; k < 5; k++){
	      if(i == 0){
	        if(j == 0){
		  routers_cmd[i][j].p_out[0][k](dspin_signals_cmd_c0[0][i][j][k]);
		  routers_cmd[i][j].p_out[1][k](dspin_signals_cmd_c1[0][i][j][k]);
		  routers_cmd[i][j].p_in[0][k](dspin_signals_cmd_c0[1][i][j][k]);
		  routers_cmd[i][j].p_in[1][k](dspin_signals_cmd_c1[1][i][j][k]);
		  routers_rsp[i][j].p_out[0][k](dspin_signals_cmd_c0[0][i][j][k]);
		  routers_rsp[i][j].p_out[1][k](dspin_signals_cmd_c1[0][i][j][k]);
		  routers_rsp[i][j].p_in[0][k](dspin_signals_cmd_c0[1][i][j][k]);
		  routers_rsp[i][j].p_in[1][k](dspin_signals_cmd_c1[1][i][j][k]);
		} else {
		  
		}
	      } else {
	      
	      }
	    }
	  }
	}

	////////////////////////////////////////////////////////



	////////////////////////////////////////////////
	//             Simulation Loop                //
	////////////////////////////////////////////////
	int ncycles;

	if (argc == 2) {
		ncycles = std::atoi(argv[1]);
	} else {
		std::cerr
			<< std::endl
			<< "The number of simulation cycles must "
			   "be defined in the command line"
			<< std::endl;
		exit(1);
	}

	sc_start(sc_core::sc_time(0, SC_NS));
	signal_resetn = false;

	sc_start(sc_core::sc_time(1, SC_NS));
	signal_resetn = true;

	for (int i = 0; i < ncycles ; i+=100000) {
		sc_start(sc_core::sc_time(100000, SC_NS));
		
	}

        std::cout << "Hit ENTER to end simulation" << std::endl;
        char buf[1];

	std::cin.getline(buf,1);
	return EXIT_SUCCESS;
}

int sc_main (int argc, char *argv[])
{
	try {
		return _main(argc, argv);
	} catch (std::exception &e) {
		std::cout << e.what() << std::endl;
	} catch (...) {
		std::cout << "Unknown exception occured" << std::endl;
		throw;
	}
	return 1;
}
