#!/usr/bin/env sh
LOGDIR=logs
COMMON="-X 5 -Y 5 -N 3000"

mkdir -p $LOGDIR
for (( x = 0; x < 5; x++ )); do
	for (( y = 0; y < 5; y++ )); do
		for (( fx = 0; fx < 5; fx++ )); do
			for (( fy = 0; fy < 5; fy++ )); do
				if [[ ( $x == $fx ) && ( $y == $fy ) ]]; then continue; fi
				LOGFILE=$LOGDIR/$(echo log'_'$x'_'$y'_'$fx'_'$fy);
				ARGS="$COMMON -SX $x -SY $y -FX $fx -FY $fy";
				echo "./simul.x $ARGS ($LOGFILE)"
				./simul.x $ARGS > $LOGFILE 2>/dev/null;
				./broadcast_check.sh $LOGFILE
				if [[ $? == 1 ]]; then
					echo "FAILURE";
					exit 1;
				fi
			done
		done
	done
done
