#!/bin/bash
#path to the tool
tool=/dsk/l1/misc/cecile/bin/vis

#parameter 1 : name of the model file
fichier=$1

# time limit
ulimit -t 28800

# name of the output file
result=resultat_grading_xun1

# file containing the register to analyse
register=register.reg
# file containing output and register to protect are supposed to be already
# generated and name :
#  protect_output.reg , protect_golde.reg

echo " " > $result
echo "Fichier : $fichier"
while read line 
do
	echo "*******************************" >> $result
	echo ${fichier}.mv >> $result
	echo "*******************************" >> $result
	echo "REG = ${line}" 
	echo "REG = ${line}" >> $result 
	echo "*******************************" >> $result

	cat protect_output.reg > protect_grade_rob4.reg
	echo $line >>  protect_grade_rob4.reg
	cat protect_golden.reg > protect_grade_rob3.reg
	for out in $(cat protect_output.reg)
	do
		echo "faulty.$out" >> protect_grade_rob3.reg
	done
    for m in $line
    do
	  echo "faulty.$m" >>  protect_grade_rob3.reg
    done
     
	echo read_blif_mv ${fichier}.mv > vis_rob_script1
	echo "init_verify" >> vis_rob_script1
	echo "dynamic_var_ordering -f sift" >> vis_rob_script1

    #ROB 4
    cat vis_rob_script1 > vis_rob_usut
	echo "echo Class USUT ROB4  ${line}" >> vis_rob_usut
	echo "set_init -v 1 -m usut -g  protect_grade_rob4.reg" >> vis_rob_usut
	echo "robustness -v 1" >> vis_rob_usut
    echo "quit -s" >> vis_rob_usut
    $tool < vis_rob_usut >> $result
#	echo "echo Class USMT ROB4 ${line}" >> vis_rob_script1
#	echo "set_init -v 1 -m usmt -g  protect_grade_rob4.reg" >> vis_rob_script1
#	echo "robustness -v 1" >> vis_rob_script1

    cat vis_rob_script1 > vis_rob_usmt
	echo "echo  Class MSUT ROB4 ${line}" >> vis_rob_usmt
	echo "set_init -v 1  -m msut -g  protect_grade_rob4.reg" >> vis_rob_usmt
	echo "robustness -v 1" >> vis_rob_usmt
    $tool < vis_rob_usmt >> $result


    cat vis_rob_script1 > vis_rob_msmt
	echo "echo Class MSMT ROB4  ${line}" >> vis_rob_msmt
	echo "set_init -v 1 -m msmt -g  protect_grade_rob4.reg" >> vis_rob_msmt
	echo "robustness -v 1" >> vis_rob_msmt
    $tool < vis_rob_msmt >> $result

    #ROB 3
	echo "compose_golden" >> vis_rob_script1
	echo "init_verify" >> vis_rob_script1
	echo "protect_golden" >> vis_rob_script1
    cat vis_rob_script1 > vis_rob_usut
	echo "echo Class  USUT  ROB3 ${line}" >> vis_rob_usut
	echo "set_init -v 1 -m usut -g protect_grade_rob3.reg" >> vis_rob_usut
	echo "robustness -v 1" >> vis_rob_usut
    $tool < vis_rob_usut >> $result

#    cat vis_rob_script1 > vis_rob_usmt
#	echo "echo Class USMT ROB3 ${line}" >> vis_rob_usmt
#	echo "set_init -v 1 -m usmt -g protect_grade_rob3.reg" >> vis_rob_usmt
#	echo "robustness -v 1" >> vis_rob_usmt
#    $tool < vis_rob_usmt >> $result

    cat vis_rob_script1 > vis_rob_msut
	echo "echo Class MSUT ROB3 ${line}" >> vis_rob_msut
	echo "set_init -v 1  -m msut -g protect_grade_rob3.reg " >> vis_rob_msut
	echo "robustness -v 1" >> vis_rob_msut
    $tool < vis_rob_msut >> $result

    cat vis_rob_script1 > vis_rob_msmt
	echo "echo Class MSMT ROB3 ${line}" >> vis_rob_msmt
	echo "set_init -v 1 -m msmt -g protect_grade_rob3.reg" >> vis_rob_msmt
	echo "robustness -v 1" >> vis_rob_msmt

    #ROB 1
    echo "set_safe safe_rob1.ctl" >> vis_rob_script1

    cat vis_rob_script1 > vis_rob_usut
	echo "echo Class USUT ROB1 ${line}" >> vis_rob_usut
	echo "set_init -v 1 -m usut -g protect_grade_rob3.reg" >> vis_rob_usut
	echo "robustness -v 1 -r 1" >> vis_rob_usut
    $tool < vis_rob_usut >> $result

#    cat vis_rob_script1 > vis_rob_usmt
#	echo "echo Class USMT ROB1 ${line}" >> vis_rob_usmt
#	echo "set_init -v 1 -m usmt -g protect_grade_rob3.reg" >> vis_rob_usmt
#	echo "robustness -v 1 -r 1" >> vis_rob_usmt
#    $tool < vis_rob_usmt >> $result

    cat vis_rob_script1 > vis_rob_msut
	echo "echo Class MSUT ROB1 ${line}" >> vis_rob_msut
	echo "set_init -v 1 -m msut -g protect_grade_rob3.reg" >> vis_rob_msut
	echo "robustness -v 1 -r 1" >> vis_rob_msut
    $tool < vis_rob_msut >> $result

    cat vis_rob_script1 > vis_rob_msmt
	echo "echo Class MSMT ROB1  ${line}" >> vis_rob_msmt
	echo "set_init -v 1 -m msmt -g protect_grade_rob3.reg" >> vis_rob_msmt
	echo "robustness -v 1 -r 1" >> vis_rob_msmt

	echo "quit -s" >> vis_rob_msmt
     ${tool} <vis_rob_msmt >> $result
	
done < $register

	


