/************************************************************************/

module  game(clk, consistent);
  input clk;
  output consistent;
  wire consistent;

wire  a11, a12, a13, a14, a15, a16, a17, a18,
      a21, a22, a23, a24, a25, a26, a27, a28,
      a31, a32, a33, a34, a35, a36, a37, a38,
      a41, a42, a43, a44, a45, a46, a47, a48,
      a51, a52, a53, a54, a55, a56, a57, a58,
      a61, a62, a63, a64, a65, a66, a67, a68,
      a71, a72, a73, a74, a75, a76, a77, a78,
      a81, a82, a83, a84, a85, a86, a87, a88;

wire h1, h2, h3, h4, h5, h6, h7, h8;
wire v1, v2, v3, v4, v5, v6, v7, v8;
wire l1, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15;
wire r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, r12, r13, r14, r15;

wire tmp1, tmp2, tmp3, tmp4, tmp5, tmp6;

assign a11 = $ND(0, 1);
assign a12 = $ND(0, 1);
assign a13 = $ND(0, 1);
assign a14 = $ND(0, 1);
assign a15 = $ND(0, 1);
assign a16 = $ND(0, 1);
assign a17 = $ND(0, 1);
assign a18 = $ND(0, 1);

assign a21 = $ND(0, 1);
assign a22 = $ND(0, 1);
assign a23 = $ND(0, 1);
assign a24 = $ND(0, 1);
assign a25 = $ND(0, 1);
assign a26 = $ND(0, 1);
assign a27 = $ND(0, 1);
assign a28 = $ND(0, 1);

assign a31 = $ND(0, 1);
assign a32 = $ND(0, 1);
assign a33 = $ND(0, 1);
assign a34 = $ND(0, 1);
assign a35 = $ND(0, 1);
assign a36 = $ND(0, 1);
assign a37 = $ND(0, 1);
assign a38 = $ND(0, 1);

assign a41 = $ND(0, 1);
assign a42 = $ND(0, 1);
assign a43 = $ND(0, 1);
assign a44 = $ND(0, 1);
assign a45 = $ND(0, 1);
assign a46 = $ND(0, 1);
assign a47 = $ND(0, 1);
assign a48 = $ND(0, 1);

assign a51 = $ND(0, 1);
assign a52 = $ND(0, 1);
assign a53 = $ND(0, 1);
assign a54 = $ND(0, 1);
assign a55 = $ND(0, 1);
assign a56 = $ND(0, 1);
assign a57 = $ND(0, 1);
assign a58 = $ND(0, 1);

assign a61 = $ND(0, 1);
assign a62 = $ND(0, 1);
assign a63 = $ND(0, 1);
assign a64 = $ND(0, 1);
assign a65 = $ND(0, 1);
assign a66 = $ND(0, 1);
assign a67 = $ND(0, 1);
assign a68 = $ND(0, 1);

assign a71 = $ND(0, 1);
assign a72 = $ND(0, 1);
assign a73 = $ND(0, 1);
assign a74 = $ND(0, 1);
assign a75 = $ND(0, 1);
assign a76 = $ND(0, 1);
assign a77 = $ND(0, 1);
assign a78 = $ND(0, 1);

assign a81 = $ND(0, 1);
assign a82 = $ND(0, 1);
assign a83 = $ND(0, 1);
assign a84 = $ND(0, 1);
assign a85 = $ND(0, 1);
assign a86 = $ND(0, 1);
assign a87 = $ND(0, 1);
assign a88 = $ND(0, 1);


single8 H1( clk, a11, a12, a13, a14, a15, a16, a17, a18, h1 );
single8 H2( clk, a21, a22, a23, a24, a25, a26, a27, a28, h2 );
single8 H3( clk, a31, a32, a33, a34, a35, a36, a37, a38, h3 );
single8 H4( clk, a41, a42, a43, a44, a45, a46, a47, a48, h4 );
single8 H5( clk, a51, a52, a53, a54, a55, a56, a57, a58, h5 );
none8 H6( clk, a61, a62, a63, a64, a65, a66, a67, a68, h6 );
none8 H7( clk, a71, a72, a73, a74, a75, a76, a77, a78, h7 );
none8 H8( clk, a81, a82, a83, a84, a85, a86, a87, a88, h8 );

single8 V1( clk, a11, a21, a31, a41, a51, a61, a71, a81, v1 );
single8 V2( clk, a12, a22, a32, a42, a52, a62, a72, a82, v2 );
single8 V3( clk, a13, a23, a33, a43, a53, a63, a73, a83, v3 );
single8 V4( clk, a14, a24, a34, a44, a54, a64, a74, a84, v4 );
single8 V5( clk, a15, a25, a35, a45, a55, a65, a75, a85, v5 );
none8 V6( clk, a16, a26, a36, a46, a56, a66, a76, a86, v6 );
none8 V7( clk, a17, a27, a37, a47, a57, a67, a77, a87, v7 );
none8 V8( clk, a18, a28, a38, a48, a58, a68, a78, a88, v8 );

maxone8 L1( clk, a11, 0,   0,   0,   0,   0,   0,   0,   l1 );
maxone8 L2( clk, a21, a12, 0,   0,   0,   0,   0,   0,   l2 );
maxone8 L3( clk, a31, a22, a13, 0,   0,   0,   0,   0,   l3 );
maxone8 L4( clk, a41, a32, a23, a41, 0,   0,   0,   0,   l4 );
maxone8 L5( clk, a51, a42, a33, a24, a15, 0,   0,   0,   l5 );
maxone8 L6( clk, a61, a52, a43, a34, a25, a16, 0,   0,   l6 );
maxone8 L7( clk, a71, a62, a53, a44, a35, a26, a17, 0,   l7 );
maxone8 L8( clk, a81, a72, a63, a54, a45, a36, a27, a18, l8 );

maxone8 L9 ( clk, a82, a73, a64, a55, a46, a37, a28, 0  , l9  );
maxone8 L10( clk, a83, a74, a65, a56, a47, a38, 0  , 0  , l10 );
maxone8 L11( clk, a84, a75, a66, a57, a48, 0  , 0  , 0  , l11 );
maxone8 L12( clk, a85, a76, a67, a58, 0  , 0  , 0  , 0  , l12 );
maxone8 L13( clk, a86, a77, a68, 0  , 0  , 0  , 0  , 0  , l13 );
maxone8 L14( clk, a87, a78, 0  , 0  , 0  , 0  , 0  , 0  , l14 );
maxone8 L15( clk, a88, 0  , 0  , 0  , 0  , 0  , 0  , 0  , l15 );

maxone8 R1( clk, a18, 0,   0,   0,   0,   0,   0,   0,   r1 );
maxone8 R2( clk, a28, a17, 0,   0,   0,   0,   0,   0,   r2 );
maxone8 R3( clk, a38, a27, a16, 0,   0,   0,   0,   0,   r3 );
maxone8 R4( clk, a48, a37, a26, a15, 0,   0,   0,   0,   r4 );
maxone8 R5( clk, a58, a47, a36, a25, a14, 0,   0,   0,   r5 );
maxone8 R6( clk, a68, a57, a46, a35, a24, a13, 0,   0,   r6 );
maxone8 R7( clk, a78, a67, a56, a45, a34, a23, a12, 0,   r7 );
maxone8 R8( clk, a88, a77, a66, a55, a44, a33, a23, a11, r8 );

maxone8 R9 ( clk, a87, a76, a65, a54, a43, a32, a21, 0  , r9  );
maxone8 R10( clk, a86, a75, a64, a53, a42, a31, 0  , 0  , r10 );
maxone8 R11( clk, a85, a74, a63, a52, a41, 0  , 0  , 0  , r11 );
maxone8 R12( clk, a84, a73, a62, a51, 0  , 0  , 0  , 0  , r12 );
maxone8 R13( clk, a83, a72, a61, 0  , 0  , 0  , 0  , 0  , r13 );
maxone8 R14( clk, a82, a71, 0  , 0  , 0  , 0  , 0  , 0  , r14 );
maxone8 R15( clk, a81, 0  , 0  , 0  , 0  , 0  , 0  , 0  , r15 );


assign tmp1 = ( h1 && h2 && h3 && h4 && h5 && h6 && h7 && h8 );
assign tmp2 = ( v1 && v2 && v3 && v4 && v5 && v6 && v7 && v8 );
assign tmp3 = ( l1 && l2 && l3 && l4 && l5 && l6 && l7 && l8 );
assign tmp4 = ( r1 && r2 && r3 && r4 && r5 && r6 && r7 && r8 );
assign tmp5 = ( l9 && l10 && l11 && l12 && l13 && l14 && l15 );
assign tmp6 = ( r9 && r10 && r11 && r12 && r13 && r14 && r15 );

assign consistent = ( tmp1 && tmp2 && tmp3 && tmp4 && tmp5 && tmp6 );


endmodule      

/************************************************************************/
module  single8(clk, x1, x2, x3, x4, x5, x6, x7, x8, out );
  input clk;
  input x1, x2, x3, x4, x5, x6, x7, x8;
  output out;

  wire x1, x2, x3, x4, x5, x6, x7, x8;
  wire out;
  wire tmp1, tmp2, tmp3, tmp4, tmp5, tmp6, tmp7, tmp8;

assign tmp1 = (  x1 && !x2 && !x3 && !x4 && !x5 && !x6 && !x7 && !x8 );
assign tmp2 = ( !x1 &&  x2 && !x3 && !x4 && !x5 && !x6 && !x7 && !x8 );
assign tmp3 = ( !x1 && !x2 &&  x3 && !x4 && !x5 && !x6 && !x7 && !x8 );
assign tmp4 = ( !x1 && !x2 && !x3 &&  x4 && !x5 && !x6 && !x7 && !x8 );
assign tmp5 = ( !x1 && !x2 && !x3 && !x4 &&  x5 && !x6 && !x7 && !x8 );
assign tmp6 = ( !x1 && !x2 && !x3 && !x4 && !x5 &&  x6 && !x7 && !x8 );
assign tmp7 = ( !x1 && !x2 && !x3 && !x4 && !x5 && !x6 &&  x7 && !x8 );
assign tmp8 = ( !x1 && !x2 && !x3 && !x4 && !x5 && !x6 && !x7 &&  x8 );


assign out =  ( tmp1 || tmp2 || tmp3 || tmp4 || tmp5 || tmp6 || tmp7 || tmp8 );

endmodule 
/************************************************************************/
module  maxone8(clk, x1, x2, x3, x4, x5, x6, x7, x8, out );
  input clk;
  input x1, x2, x3, x4, x5, x6, x7, x8;
  output out;

  wire x1, x2, x3, x4, x5, x6, x7, x8;
  wire out;
  wire tmp0, tmp1, tmp2, tmp3, tmp4, tmp5, tmp6, tmp7, tmp8;

assign tmp0 = ( !x1 && !x2 && !x3 && !x4 && !x5 && !x6 && !x7 && !x8 );
assign tmp1 = (  x1 && !x2 && !x3 && !x4 && !x5 && !x6 && !x7 && !x8 );
assign tmp2 = ( !x1 &&  x2 && !x3 && !x4 && !x5 && !x6 && !x7 && !x8 );
assign tmp3 = ( !x1 && !x2 &&  x3 && !x4 && !x5 && !x6 && !x7 && !x8 );
assign tmp4 = ( !x1 && !x2 && !x3 &&  x4 && !x5 && !x6 && !x7 && !x8 );
assign tmp5 = ( !x1 && !x2 && !x3 && !x4 &&  x5 && !x6 && !x7 && !x8 );
assign tmp6 = ( !x1 && !x2 && !x3 && !x4 && !x5 &&  x6 && !x7 && !x8 );
assign tmp7 = ( !x1 && !x2 && !x3 && !x4 && !x5 && !x6 &&  x7 && !x8 );
assign tmp8 = ( !x1 && !x2 && !x3 && !x4 && !x5 && !x6 && !x7 &&  x8 );

assign out =  ( tmp0 || tmp1 || tmp2 || tmp3 || tmp4 || tmp5 || tmp6 || tmp7 || tmp8 );

endmodule 

/************************************************************************/
module  none8(clk, x1, x2, x3, x4, x5, x6, x7, x8, out );
  input clk;
  input x1, x2, x3, x4, x5, x6, x7, x8;
  output out;

  wire x1, x2, x3, x4, x5, x6, x7, x8;
  wire out;

assign out =  ( !x1 && !x2 && !x3 && !x4 && !x5 && !x6 && !x7 && !x8 );

endmodule 
