/**CHeaderFile*****************************************************************

  FileName    [util.h] 
 
  PackageName [sat]

  Synopsis    []
  
  Author      [Hoonsang Jin, Hyojung Han]

  Copyright   [Copyright (c) 1995-2004, Regents of the University of Colorado

  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

  Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in the
  documentation and/or other materials provided with the distribution.

  Neither the name of the University of Colorado nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.]
  
******************************************************************************/

#include <string.h>
#include "sat.h"
#include "stdio.h"
#include "malloc.h"
/*#include "mm.h" */

#define heap_left(i)	((i<<1)+1)
#define heap_right(i)	((i+1)<<1)
#define heap_parent(i)	((i-1)>>1)

/**
static int
sat_compare_activity(satManager_t *m, long x, long y)
{
  return(m->activity[x] > m->activity[y]);
}
**/

void
sat_heap_remove_var_assigned_level_zero(satManager_t *m, satHeap_t *h)
{
long i, j;
 
  for(i=j=0; i<h->size; i++) {
    if(m->levels[h->heap[i]]) {
      h->heap[j] = h->heap[i];
      h->indices[h->heap[i]] = j++;
    }
    else {
      h->indices[h->heap[i]] = -1;
    }
  }
  h->size -= (i-j);

  for(i=h->size/2-1; i>=0; i--) 
    sat_heap_down(m, h, i);
}

void 
sat_heap_up(satManager_t *m, satHeap_t *h, long i)
{
long *heap;
long x;

  heap = h->heap;
  x = heap[i];
  while(i!=0 && h->compare(m->activity, (const void*)x, (const void*)heap[heap_parent(i)])) {
    heap[i] = heap[heap_parent(i)];
    h->indices[heap[i]] = i;
    i = heap_parent(i);
  }
  h->heap[i] = x;
  h->indices[x] = i;
}

void
sat_heap_down(satManager_t *m, satHeap_t *h, long i)
{
long *heap;
long x, c;

  heap = h->heap;
  x = heap[i];
  while(heap_left(i) < h->size) {
    c = (heap_right(i) < h->size && 
	h->compare(m->activity, (const void *)heap[heap_right(i)], (const void *)heap[heap_left(i)])) ?
	heap_right(i) : heap_left(i);
    if(!h->compare(m->activity, (const void *)heap[c], (const void *)x))	break;
    heap[i] = heap[c];
    h->indices[heap[i]] = i;
    i = c;
  }
  heap[i] = x;
  h->indices[x] = i;
}

long
sat_heap_remove_min(satManager_t *m, satHeap_t *h)
{
long x;
 
  x = h->heap[0];
  h->heap[0] = h->heap[h->size-1];
  h->indices[h->heap[0]] = 0;
  h->indices[x] = -1;
  h->size--;
  if(h->size > 1)	
    sat_heap_down(m, h, 0);

  return(x);
}

void
sat_heap_clear(satHeap_t *h)
{
long i;
 
  for(i=0; i<h->size; i++)
    h->indices[h->heap[i]] = -1;
  h->size = 0;
}

void
sat_heap_update(satManager_t *m, satHeap_t *h, long n)
{
 
  if(h->indices[n] < 0)
    sat_heap_insert(m, h, n);
  else {
    sat_heap_up(m, h, h->indices[n]);
    sat_heap_down(m, h, h->indices[n]);
  }
}

satHeap_t *
sat_heap_init(satManager_t *m, int (*compare_heap)(void *, const void *, const void *))
{
satHeap_t *h;
long nVars, i;
  

  h = (satHeap_t *)malloc(sizeof(satHeap_t));
  h->size = 0;

  nVars = m->nVars+1;
  h->heap = (long *)malloc(sizeof(long)*nVars);
  h->indices = (long *)malloc(sizeof(long)*nVars);
  for(i=0; i<nVars; i++) h->indices[i] = -1;
  h->compare = compare_heap;

  return(h);
}

void
sat_heap_resize(satManager_t *m, satHeap_t *h, long prenVars)
{
long nVars, i;
  
  nVars = m->nVars+1;
  h->heap = (long *)realloc(h->heap, sizeof(long)*nVars);
  h->indices = (long *)realloc(h->indices, sizeof(long)*nVars);
  for(i=prenVars; i<nVars; i++) h->indices[i] = -1;
}

void
sat_heap_print(satManager_t *m, satHeap_t *h)
{
int i;

  h = m->variableHeap;
  for(i=0; i<=m->nVars; i++) {
    fprintf(stdout, "%d ", i);
    fprintf(stdout, "%ld ", h->heap[i]);
    fprintf(stdout, "%10g", m->activity[h->heap[i]]);
    fprintf(stdout, "\n");
  }
}

void
sat_heap_free(satHeap_t *h)
{
  if(h) {
    free(h->heap);
    free(h->indices);
    free(h);
  }
}

int
sat_heap_check(satManager_t *m, satHeap_t *h, long i)
{
  if(i >= h->size) return(1);

  if(i==0 || !sat_compare_activity(m, (const void *)h->heap[i], (const void *)h->heap[heap_parent(i)])) {
    return( sat_heap_check(m, h, heap_left(i)) && sat_heap_check(m, h, heap_right(i)));
  }
  return(0);
      
}


void
sat_heap_insert(satManager_t *m, satHeap_t *h, long n)
{

  h->indices[n] = h->size;
  h->heap[h->size++] = n;
  sat_heap_up(m, h, h->indices[n]);
}

satArray_t *
sat_array_alloc(long num)
{
satArray_t *arr;
   arr = (satArray_t *)malloc(sizeof(satArray_t) + sizeof(long)*num);
   if(arr == 0) return(0);
   arr->total = num;
   arr->size = 0;
   return(arr); 
}

satArray_t *
sat_array_insert(satArray_t *arr, long datum)
{
satArray_t *nArr;

   if(arr->size < arr->total) {
       arr->space[arr->size++] = datum;
   }
   else {
       nArr = sat_array_alloc(arr->total<<1);
       memcpy(&(nArr->space[0]), &(arr->space[0]), sizeof(long)*arr->total);
       nArr->size = arr->size;
       free(arr);
       arr = nArr;
       arr->space[arr->size++] = datum;
   }
   return(arr);
} 

satArray_t *
sat_array_realloc(satArray_t *arr, long size)
{
satArray_t *nArr;

   if(size >= arr->total) {
     nArr = sat_array_alloc(size);
     nArr->total = size;
     memcpy(&(nArr->space[0]), &(arr->space[0]), sizeof(long)*arr->total);
     nArr->size = arr->size;
     free(arr);
     arr = nArr;
   }
   return(arr);
} 

satArray_t *
sat_array_alloc_insert(satArray_t *arr, long datum)
{
satArray_t *nArr;

   if(arr == 0)	arr = sat_array_alloc(4);

   if(arr->size < arr->total) {
       arr->space[arr->size++] = datum;
   }
   else {
     nArr = sat_array_alloc(arr->total<<1);
     memcpy(&(nArr->space[0]), &(arr->space[0]), sizeof(long)*arr->total);
     nArr->size = arr->size;
     free(arr);
     arr = nArr;
     arr->space[arr->size++] = datum;
   }
   return(arr);
} 

satArray_t *
sat_array_copy(satArray_t *arr1, satArray_t *arr2)
{
satArray_t *nArr;

  if(arr2 == 0) {
    arr2 = (satArray_t *)malloc(sizeof(satArray_t) + sizeof(long)*arr1->size);
    if(arr2 == 0) return(0);
    arr2->total = arr1->size;
    arr2->size = 0;
  }
  if(arr1->size > arr2->total) {
    nArr = sat_array_alloc(arr1->size);
    free(arr2);
    arr2 = nArr;
  }
  memcpy(&(arr2->space[0]), &(arr1->space[0]), sizeof(long)*arr1->size);
  arr2->size = arr1->size;
  return(arr2);
}

void
sat_array_delete_elem(satArray_t *arr, long elem)
{
int i, index;

  for(i=0; i<arr->size && arr->space[i] != elem; i++);
  index = arr->size-1;
  for(; i<index; i++)	arr->space[i] = arr->space[i+1];
  arr->size--;
}


void
sat_sort_clause_array(satArray_t *arr, int (*compare_sort)(const void *, const void *))
{

  sat_sort_clause_array_aux(&(arr->space[0]), arr->size, compare_sort);
}

void
sat_sort_clause_array_aux(long *carr, long size,  int (*compare_sort)(const void *, const void *))
{
long i, j, tmp, bi;
satClause_t *pivot;
satClause_t *x, *y;

  if(size <=15) {
    for(i=0; i<size-1; i++) {
      bi = i;
      for(j=i+1; j<size; j++) {
	x = ((satClause_t *)(carr[j]));
	y = ((satClause_t *)(carr[bi]));
	/**
	if((SATSizeClause(x)) > 2 && ((SATSizeClause(y)) == 2 || x->info.activity < y->info.activity)) 
	**/
	if((*(compare_sort))(x, y))
	  bi = j;
      }
      tmp = carr[i];
      carr[i] = carr[bi];
      carr[bi] = tmp;
    }
  }
  else {
    pivot = (satClause_t *)carr[(size>>1)];
    i = -1;
    j = size;

    while(1) {
	/**
      do i++; while( (SATSizeClause(((satClause_t *)(carr[i])))) > 2 && (SATSizeClause(pivot) == 2 ||
	      ((satClause_t *)(carr[i]))->info.activity < pivot->info.activity));
      do j--; while( (SATSizeClause(pivot)) > 2 && ((SATSizeClause(((satClause_t *)(carr[j])))) == 2 ||
	      pivot->info.activity < ((satClause_t *)(carr[j]))->info.activity));
	      **/
      do i++; while( (*(compare_sort))((const void *)carr[i], (const void *)pivot));
      do j--; while( (*(compare_sort))((const void *)pivot, (const void *)carr[j]));
      if(i>=j)	break;
      tmp = carr[i];
      carr[i] = carr[j];
      carr[j] = tmp;
    }
    sat_sort_clause_array_aux(carr, i, compare_sort);
    sat_sort_clause_array_aux(&(carr[i]), size-i, compare_sort);
  }
}

void
sat_sort_clause_literal(satClause_t *c)
{
long csize;

  csize = SATSizeClause(c);
  sat_sort_literal_aux(&(c->lits[0]), csize);
}

void
sat_literal_array_sort(satArray_t *arr)
{

  sat_sort_literal_aux(&(arr->space[0]), arr->size);
}


void
sat_sort_literal_aux(long *lits, long size)
{
long i, j, tmp, bi;
long pivot;

  if(size <=15) {
    for(i=0; i<size-1; i++) {
      bi = i;
      for(j=i+1; j<size; j++) {
	if(lits[j] < lits[bi])
	  bi = j;
      }
      tmp = lits[i];
      lits[i] = lits[bi];
      lits[bi] = tmp;
    }
  }
  else {
    pivot = lits[size>>1];
    i = -1;
    j = size;

    while(1) {
      do i++; while(lits[i] < pivot);
      do j--; while(pivot < lits[j]);
      if(i>=j)	break;
      tmp = lits[i];
      lits[i] = lits[j];
      lits[j] = tmp;
    }
    sat_sort_literal_aux(lits, i);
    sat_sort_literal_aux(&(lits[i]), size-i);
  }
}

/** HHJ : remove duplicates **/
/*
satQueue_t *
sat_queue_alloc(long num)
{
satArray_t *arr;
satQueue_t *q;

   arr = (satArray_t *)malloc(sizeof(satArray_t) + sizeof(long)*num);
   if(arr == 0) return(0);
   arr->total = num;
   arr->size = 0;
   q = (satQueue_t *)malloc(sizeof(satQueue_t));
   q->arr = arr;
   q->first = 0;
   return(q); 
}

void
sat_queue_insert(satQueue_t *q, long datum)
{
   q->arr = sat_array_insert(q->arr, datum);
}

long
sat_queue_pop(satQueue_t *q)
{
long datum;
int i, j;
satArray_t *arr;

   arr = q->arr;
   if(q->first > 1024) {
     for(i=q->first,j=0; i<arr->size; i++) {
       arr->space[j++] = arr->space[i]; 
     }
     arr->size = arr->size - q->first;
     q->first = 0;
   }
   datum = arr->space[q->first];
   q->first++;
   return(datum);
}

long
sat_queue_size(satQueue_t *q)
{
  return(q->arr->size - q->first);
}

void
sat_queue_free(satQueue_t *q)
{
  free(q->arr);
  free(q);
}
*/

int
sat_compress_clause(satManager_t *m, satClause_t *c)
{
long i, j, csize;
long lit, v, preLit;
int sign, value;

  preLit = 0;
  csize = SATSizeClause(c);
  for (i=j=0; i<csize; i++) {
    lit = c->lits[i];
    v = lit >> 1;   
    value = m->values[v];
    sign = lit & 1;
    if (lit == (preLit^1)) 
      return 1;
    else if (lit != preLit)
      c->lits[j++] = preLit = c->lits[i]; 
  }
  c->size = ((csize - i + j) << SATCsizeShift) | (c->size & SATCMask); 
  return 0;  
}


