/**CFile***********************************************************************

  FileName    [smtGraph.c]

  PackageName [smt]

  Synopsis    [Routines for smt function.]

  Author      [Hyondeuk Kim]

  Copyright   [Copyright (c) 1995-2004, Regents of the University of Colorado

  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

  Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in the
  documentation and/or other materials provided with the distribution.

  Neither the name of the University of Colorado nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.]

******************************************************************************/

#ifdef HAVE_LIBGMP

#include "smt.h"
 
smtVertex_t *
smt_add_vertex(smtGraph_t * G, int vindex)
{
  smtVertex_t *v; 

  v = &(G->vHead[vindex]);

  v->ins = sat_array_alloc(10);
  v->outs = sat_array_alloc(10);
  v->targets = sat_array_alloc(10);

  v->index = vindex;
 
  return(v);
}

smtEdge_t *
smt_add_edge(
  smtGraph_t * G, 
  smtVertex_t * s, 
  smtVertex_t * d, 
  smtAvar_t * avar,
  int eindex)
{
  smtEdge_t *e;

  e = &(G->eHead[eindex]);
  e->index = eindex;
  
  e->src = s;
  e->dest = d;

  s->outs = sat_array_insert(s->outs, (long) e);
  d->ins = sat_array_insert(d->ins, (long) e);  

  if (!e->implied) {
    e->implied = sat_array_alloc(8);
    G->imp_edges = sat_array_insert(G->imp_edges, (long) e);
  }

  e->avar = avar;

  return(e); 
}

smtEdge_t * 
smt_find_edge(smtVertex_t * s, smtVertex_t * d)
{
  smtEdge_t *e;
  int i;
  
  for(i = 0; i < s->outs->size; i++) {
    e = (smtEdge_t *) s->outs->space[i];
    if(e->dest == d)
      return(e);
  }
  return(0);
}

#endif


