/**CFile***********************************************************************

  FileName    [main.c]

  PackageName [smt]

  Synopsis    [Routines for main function.]

  Author      [Hyondeuk Kim]

  Copyright   [Copyright (c) 1995-2004, Regents of the University of Colorado

  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

  Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in the
  documentation and/or other materials provided with the distribution.

  Neither the name of the University of Colorado nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.]

******************************************************************************/

#ifdef HAVE_LIBGMP

#include <setjmp.h>
#include <signal.h>
#include "smt.h"

static char rcsid[] UNUSED = "$Id $";

int
main(int argc, char ** argv)
{
  char *filename = 0;
  int is_smt = 1, is_model = 0, timeout = -1;
  int i;
  satArray_t *sat_options;
 
  sat_options = sat_array_alloc(3);
  for (i = 0; i < 3; i++)  
    sat_array_insert(sat_options, 0);

  fprintf(stdout, "c %s (compiled %s)\n", 
	  CUR_VER,  DateReadFromDateString(CUR_DATE));

  if (argc <= 2) { 

    if (argc < 2 || !strcmp (argv[1], "-h")) {
      goto usage;
    } 
    
    filename = strdup(argv[1]);
    smt_main(filename, timeout, is_model);
    
    return 0;    
  }
  
  for (i = 1; i < argc; i++) {
    
    if (!strcmp (argv[i], "-smt")) {
      
      filename = strdup(argv[i+1]);
      
    } else if (!strcmp (argv[i], "-cnf")) {
      
      filename = strdup(argv[i+1]);
      is_smt = 0;
      
    } else if (!strcmp (argv[i], "-t")) {
      
      timeout = atoi(argv[i+1]);      
      
    } else if (!strcmp (argv[i], "-model")) {

      is_model = 1;
      
    } else if (!strcmp (argv[i], "-quiet")) {

      sat_options->space[0] = 1;
      
    } else if (!strcmp (argv[i], "-velim")) {

      sat_options->space[1] = 1;
      
    } else if (!strcmp (argv[i], "-distill")) {

      sat_options->space[2] = 1;
      
    } else if (i == 1) {

      filename = strdup(argv[i]);
      
    }
  }

  if (!filename)   goto usage;

  if (is_smt) {
    /* e.g. cusp -smt file */
    smt_main(filename, timeout, is_model);
    
  } else {
    /* e.g. cusp -cnf file */
    sat_main(filename, timeout, sat_options);
  }

  return 0;

usage:
  (void) fprintf(stderr, "USAGE: cusp [-h] [problem] <input-file> [problem-options] [-t <seconds>]\n\n");
  (void) fprintf(stderr, "-h       	print the command usage\n\n");
  (void) fprintf(stderr, "PROBLEM:\n\n");
  (void) fprintf(stderr, "  -smt        Satisfiability Modulo Theories (default) \n");
  (void) fprintf(stderr, "  -cnf        Propositional Satisfiability\n\n");
  (void) fprintf(stderr, "SMT-OPTIONS:\n\n");
  (void) fprintf(stderr, "  -model 	print a SMT solution (default 0)\n");
  (void) fprintf(stderr, "CNF-OPTIONS:\n\n");
  (void) fprintf(stderr, "  -quiet 	suppress printing solution (default 0)\n");
  (void) fprintf(stderr, "  -velim    	preprocess based on variable elimination (default 0)\n");
  (void) fprintf(stderr, "  -distill   	preprocess based on clause distillation (default 0)\n");
  (void) fprintf(stderr, "\n");

  return 1;
}

#endif

