%{
/**CFile***********************************************************************

  FileName    [smt.l]
 
  PackageName [smt]

  Synopsis    [Lexical analyzer for formula parser. See smt.h for syntax.]

  Author      [Hyondeuk Kim]

  Copyright   [Copyright (c) 1995-2004, Regents of the University of Colorado

  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

  Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in the
  documentation and/or other materials provided with the distribution.

  Neither the name of the University of Colorado nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.]

******************************************************************************/

#ifdef HAVE_LIBGMP

#include "smtRead.h"

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/


/**AutomaticEnd***************************************************************/



/*---------------------------------------------------------------------------*/
/* Definition of internal functions                                          */
/*---------------------------------------------------------------------------*/

/**Function********************************************************************

  Synopsis    [Initializes global variables for parsing file.]

  SideEffects []

******************************************************************************/
void
SmtFileSetup(
  FILE * fp)
{
  SmtYyin             = fp;
}

/*---------------------------------------------------------------------------*/
/* Definition of static functions                                            */
/*---------------------------------------------------------------------------*/

/**Function********************************************************************

  Synopsis    [Prints error message and sets global error flag.]

  SideEffects []

******************************************************************************/
static void
SmtYyerror(
  char * errmsg)
{
  (void) fprintf(stderr, "%s in with token \"%s\"\n", errmsg, yytext); 
}

%}

/*---------------------------------------------------------------------------*/
/*      Lexical analyzer rules                                               */
/*---------------------------------------------------------------------------*/

%option noyywrap

/* substitution strings */
/* alnum is the same set in alnumsymbol in io.l except [ and ] being
removed here for the until operator */
/* - , =, and ; are intentionally removed
   - is used for -> and <->
   = is used for foo = bar 
   ; is used for delimitters */
/* ( and ) are intentionally removed since they are used as parentheses */
/* +, *, and ^ have to be used surrounded by spaces
since they are symbols. ! can be attached immediately w/o spaces though
since it is not a symbol */
/*alnum		[A-Za-z0-9\^\?\|\/\$\<\>~@\_#\$%\"\'\.]**/
/*num             [0-9]+*/
%%

[ \t\n\r]	;

"#".*   ;   

true { return(TRUE_TOK); }
false { return(FALSE_TOK); }
ite { return(ITE_TOK); }
not { return(NOT_TOK); }
implies { return(IMPLIES_TOK); }
if_then_else { return(IF_THEN_ELSE_TOK); }
and { return(AND_TOK); }
or { return(OR_TOK); }
xor { return(XOR_TOK); }
iff { return(IFF_TOK); }
exists { return(EXISTS_TOK); }
forall { return(FORALL_TOK); }
let { return(LET_TOK); } 
flet { return(FLET_TOK); }
[\"][^\"]*[\"] { return(STRING_TOK); }
[\{][^\{]*[\}] { return(USER_VAL_TOK); }
notes { return(NOTES_TOK); }
sorts { return(SORTS_TOK); }
funs { return(FUNS_TOK); }
preds { return(PREDS_TOK); }
extensions { return(EXTENSIONS_TOK); }
definition { return(DEFINITION_TOK); }
axioms { return(AXIOMS_TOK); }
logic { return(LOGIC_TOK); }
":" { return(COLON_TOK); }
"(" { return(LPAREN_TOK); }
")" { return(RPAREN_TOK); }
sat { return(SAT_TOK); }
unsat { return(UNSAT_TOK); }
unknown { return(UNKNOWN_TOK); }
assumption { return(ASSUMPTION_TOK); }
formula { return(FORMULA_TOK); }
status { return(STATUS_TOK); }
benchmark { return(BENCHMARK_TOK); }
extrasorts { return(EXTRASORTS_TOK); }
extrafuns { return(EXTRAFUNS_TOK); }
extrapreds { return(EXTRAPREDS_TOK); }
language { return(LANGUAGE_TOK); }
"=" { return(EQUALS_TOK); }
distinct { return(DISTINCT_TOK); }
"$" { return(DOLLAR_TOK); }


[\=\<\>\&@#\+\-\*\/%\|~]+		{ return(AR_SYMB); }
[0-9]+			        	{ return(NUMERAL_TOK); }
[?][a-zA-Z][a-zA-Z\.\_0-9]*   		{ return(VAR_TOK); }
[a-zA-Z\/][a-zA-Z\.\'\-\+\/\_\\0-9]*	{ return(SYM_TOK); }


%%

#endif
