/**CHeaderFile*****************************************************************

  FileName    [AigInt.h]

  PackageName [Aig]

  Synopsis    []

  Description [Internal data structures of the Aig package.]

  SeeAlso     []

  Author      [Mohammad Awedh]

  Copyright [ This file was created at the University of Colorado at
  Boulder.  The University of Colorado at Boulder makes no warranty
  about the suitability of this software for any purpose.  It is
  presented on an AS IS basis.]

  Revision    [$Id: aigInt.h,v 1.1.1.1 2008-11-14 20:40:10 hhkim Exp $]

******************************************************************************/

#ifndef _AigINT
#define _AigINT

#include "util.h"
#include "array.h"
#include "aig.h"

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/

/* Each node occupies 8 location.  The following describes these locations */

/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/




/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN void AigSetPassFlag(Aig_Manager_t *manager, AigEdge_t node);
EXTERN void AigResetPassFlag(Aig_Manager_t *manager, AigEdge_t node);
EXTERN int AigGetPassFlag(Aig_Manager_t *manager, AigEdge_t node);
EXTERN AigEdge_t AigCreateAndNode(Aig_Manager_t *manager, AigEdge_t node1, AigEdge_t node2);
EXTERN int AigCheckInvariantWithAG( AigTransition_t *t, AigEdge_t objective);
EXTERN void AigCleanUpDataFromPreviousExecution(AigTransition_t *t);
EXTERN AigEdge_t AigBuildObjectiveFromFrontierSet(AigTransition_t *t);
EXTERN void Aig_ComputeAX(AigTransition_t *t);


/**AutomaticEnd***************************************************************/

#endif /* _AigINT */
