/**CFile***********************************************************************

  FileName    [smtPre.c]

  PackageName [smt]

  Synopsis    [Routines for smt function.]

  Author      [Hyondeuk Kim]

  Copyright   [Copyright (c) 1995-2004, Regents of the University of Colorado

  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

  Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in the
  documentation and/or other materials provided with the distribution.

  Neither the name of the University of Colorado nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.]

******************************************************************************/

#ifdef HAVE_LIBGMP

#include "util.h"
#include "smt.h"

void
smt_preprocess(smtManager_t * sm)
{
  if (sm->flag & IDL_MASK || sm->flag & RDL_MASK) 
    smt_dl_preprocess(sm);
  else
    exit(0);  
}

void
smt_update_nvar_adjacent_avar_array(smtManager_t * sm)
{
  /* this is included in smt_create_atom_variable_main */

  smtAvar_t * avar;
  smtNvar_t * nvar;
  int size, prev_num, cur_num;
  int i, j;

  if (sm->avarArr->size == 0) return;

  for(i = 0, prev_num = 0; i < sm->nvarArr->size; i++) {
    nvar = (smtNvar_t *) sm->nvarArr->space[i];
    if (nvar->avarArr) {
      prev_num += nvar->avarArr->size;
      nvar->avarArr->size = 0;
    }
  }

  size = 3 * (sm->avarArr->size / sm->nvarArr->size + 1);

  for(i = 0, cur_num = 0; i < sm->avarArr->size; i++) {
    avar = (smtAvar_t *) sm->avarArr->space[i];

    for(j = 0; j < avar->nvars->size; j++) {
      nvar = (smtNvar_t *) avar->nvars->space[j];
      if (!nvar->avarArr) nvar->avarArr = sat_array_alloc(size);
      if ( sm->avalues[avar->id] == 2 ) {
	cur_num++;
	nvar->avarArr = sat_array_insert(nvar->avarArr, (long) avar);
      }
    }
  }

  return;
}

void
smt_dl_preprocess(smtManager_t * sm)
{
  smt_convert_atom_to_dl_form(sm);  

  smt_generate_avar_sister_array(sm);
}

void
smt_convert_atom_to_dl_form(smtManager_t * sm)
{
  smtAvar_t * avar;
  smtNvar_t * nvar_a, * nvar_b;
  double coeff_a, coeff_b;
  int i;

  for(i = 0; i < sm->avarArr->size; i++) {
    avar = (smtAvar_t *) sm->avarArr->space[i];
    coeff_a = array_fetch(double, avar->coeffs, 0);
    coeff_b = array_fetch(double, avar->coeffs, 1);

    if (avar->type == GE_c) {
      avar->constant = -avar->constant;
      coeff_a = -coeff_a;
      coeff_b = -coeff_b;      
    } else if (avar->type == LT_c) {
      avar->constant = avar->constant - sm->epsilon;     
    } else if (avar->type == GT_c) {
      avar->constant = -avar->constant - sm->epsilon;
      coeff_a = -coeff_a;
      coeff_b = -coeff_b;
    }

    if (coeff_a > 0) {
      assert(coeff_a == 1 && coeff_b == -1);	
      /* no change */
    } else {
      assert(coeff_b == 1 && coeff_a == -1);	
      array_insert(double, avar->coeffs, 0, 1);
      array_insert(double, avar->coeffs, 1, -1);
      nvar_a = (smtNvar_t *) avar->nvars->space[0];
      nvar_b = (smtNvar_t *) avar->nvars->space[1];
      /* swap */
      avar->nvars->space[0] = (long) nvar_b;
      avar->nvars->space[1] = (long) nvar_a;
    }
  }

  return;
}

void
smt_generate_avar_sister_array(smtManager_t * sm)
{
  smtAvar_t * avar;
  smtNvar_t * lnvar, * rnvar, * tnvar;
  array_t * sis_avars;
  st_table * sis_table = st_init_table(strcmp, st_strhash);
  char * key;
  int i;

  sm->sis_table = sis_table;

  for(i = 0; i < sm->avarArr->size; i++) {
    avar = (smtAvar_t *) sm->avarArr->space[i];
    lnvar = (smtNvar_t *) avar->nvars->space[0];
    rnvar = (smtNvar_t *) avar->nvars->space[1];

    if (lnvar->id > rnvar->id) {
      tnvar = lnvar;
      lnvar = rnvar;
      rnvar = tnvar;
    }

    key = util_strcat3(lnvar->name, rnvar->name, "");

    if (st_lookup(sis_table, key, (char **)&(sis_avars))) {
      array_insert_last(smtAvar_t *, sis_avars, avar);
      avar->sis_avars = sis_avars;
      free(key);
    } else {
      sis_avars = array_alloc(smtAvar_t *, 10);
      array_insert_last(smtAvar_t *, sis_avars, avar);	
      st_insert(sis_table, key, (char *) sis_avars);
      avar->sis_avars = sis_avars;
    }
  }

  return;
}

void
smt_put_la_clause_to_clause_arr(smtManager_t * sm)
{
  smtCls_t * cls;
  int i;

  if (sm->la_clsArr == 0) return;

  for(i = 0; i < sm->la_clsArr->size; i++) {
    cls = (smtCls_t *) sm->la_clsArr->space[i];
    sm->clsArr = sat_array_insert(sm->clsArr, (long) cls);
  }

  return;
}

#endif
