/**CHeaderFile*****************************************************************

  FileName    [io.h]

  PackageName [io]

  Synopsis    [Routines for reading and writing BLIF-MV files.]

  Author      [Yuji Kukimoto]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. of California.
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.]

  Revision    [$Id: io.h,v 1.8 2005/04/27 02:55:37 fabio Exp $]

******************************************************************************/

#ifndef _IO_VIS
#define _IO_VIS

#include "hrc.h"
#include <setjmp.h>


/**Enum************************************************************************

  Synopsis    [Types of encodings allowed.]

  Description []

  SeeAlso     []

******************************************************************************/
typedef enum {
    SIMPLE,
    OTHER
} Io_Encoding_Type_t;

/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN void Io_Init(void);
EXTERN void Io_End(void);
EXTERN Hrc_Manager_t * Io_BlifMvRead(FILE *fp, Hrc_Manager_t *hmgr, boolean isCanonical, boolean isIncremental, boolean isVerbose);
EXTERN Hrc_Manager_t * Io_BlifRead(char *fileName, boolean isVerbose);
EXTERN void Io_SmvPrintVar(FILE *fp, Var_Variable_t *var);
EXTERN int Io_HnodeWriteBlif(Io_Encoding_Type_t encodingType, Hrc_Node_t *hnode, FILE *fp, FILE *encFp, int verbosity, int combinationalOnly, int makeLatchIOsPOs);
EXTERN int Io_HnodeWriteBlifTotal(Io_Encoding_Type_t encodingType, Hrc_Node_t *hnode, FILE *fp, int verbosity);
EXTERN void Io_SmvPrintVar(FILE *fp, Var_Variable_t *var);

/**AutomaticEnd***************************************************************/

#endif /* _IO_VIS */
