/**CFile***********************************************************************

  FileName    [ioWriteBlifMv.c]

  PackageName [io]

  Synopsis    [Writes out a blif-mv file.]

  Description []

  SeeAlso     []

  Author      [Yuji Kukimoto]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. of California.
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.]

******************************************************************************/

#include "ioInt.h"

static char rcsid[] UNUSED = "$Id: ioWriteBlifMv.c,v 1.8 1998/09/24 00:07:34 hsv Exp $";

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Stucture declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/


/**AutomaticEnd***************************************************************/


/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Definition of internal functions                                          */
/*---------------------------------------------------------------------------*/


/**Function********************************************************************

  Synopsis    [The top-level routine for writing out a BLIF-MV file.]

  Description [The top-level routine for writing out a blif-mv file.
  The user has to check if the hmgr has a hierarchy read in before
  calling this procedure.]

  SideEffects []

  SeeAlso     []

******************************************************************************/
void
IoBlifMvWrite(
  FILE *fp,
  Hrc_Manager_t *hmgr)
{ 
  char *rootModelName;
  Hrc_Model_t *model, *rootModel;
  Hrc_Node_t *currentNode;
  array_t *models;
  int i;
  boolean isRootModel;
  char *rootInstanceName, *instanceName;
  
  currentNode = Hrc_ManagerReadCurrentNode(hmgr);
  models = Hrc_ManagerObtainComponentModels(hmgr);

  rootModelName = Hrc_NodeReadModelName(currentNode);
  rootModel = Hrc_ManagerFindModelByName(hmgr,rootModelName);
  rootInstanceName = Hrc_NodeReadInstanceName(currentNode);
  assert(rootModel != NIL(Hrc_Model_t));
  
  for (i=0; i < array_n(models); i++){
    model = array_fetch(Hrc_Model_t *,models,i);
    isRootModel = (model == rootModel) ? TRUE : FALSE;
    instanceName = (isRootModel == TRUE) ? rootInstanceName : NIL(char);
    Hrc_ModelWriteBlifMv(fp,model,isRootModel,instanceName);
  }  

  array_free(models);
}

/**Function********************************************************************

  Synopsis    [Prints out .mv declaration for a given variable.]

  Description [Prints out .mv declaration for a given variable.]

  SideEffects []

  SeeAlso     []

******************************************************************************/
void
IoMvPrint(
  FILE *fp,
  Var_Variable_t *var)
{
  int is_enum, range, i;

  is_enum = Var_VariableTestIsEnumerative(var);
  range = Var_VariableReadNumValues(var);
    
  if (is_enum == 1){
    if (range == 2){
      /* Boolean enumerative variables need no .mv declaration. */
      return;
    }
    else {
      (void)fprintf(fp,".mv %s %d\n",Var_VariableReadName(var),range);
    }
  }
  else {
  /* variable var is symbolic */
    (void)fprintf(fp,".mv %s %d ",Var_VariableReadName(var),range);
    for (i=0; i < range; i++){
      (void)fprintf(fp,"%s ",Var_VariableReadSymbolicValueFromIndex(var,i));
    }
    (void)fprintf(fp,"\n");
  }
}

/**Function********************************************************************

  Synopsis    [Prints out .mv declaration for a given variable, with the special
               string "_bufin" appended to the variable name.]

  Description [Prints out .mv declaration for a given variable.]

  SideEffects []

  SeeAlso     []

******************************************************************************/
void
IoMvPrintSpecial(
  FILE *fp,
  Var_Variable_t *var)
{
  int is_enum, range, i;

  is_enum = Var_VariableTestIsEnumerative(var);
  range = Var_VariableReadNumValues(var);
    
  if (is_enum == 1){
    if (range == 2){
      /* Boolean enumerative variables need no .mv declaration. */
      return;
    }
    else {
      (void)fprintf(fp,".mv %s_bufin %d\n",Var_VariableReadName(var),range);
    }
  }
  else {
  /* variable var is symbolic */
    (void)fprintf(fp,".mv %s_bufin %d ",Var_VariableReadName(var),range);
    for (i=0; i < range; i++){
      (void)fprintf(fp,"%s ",Var_VariableReadSymbolicValueFromIndex(var,i));
    }
    (void)fprintf(fp,"\n");
  }
}



