/**CHeaderFile*****************************************************************

  FileName    [mvfaig.h]

  PackageName [mvfaig]

  Synopsis    [Creation and manipulation of AndInv-based multi-valued functions.]

  Description [.]

  Author      [Mohammad Awedh]

  Copyright [ This file was created at the University of Colorado at
  Boulder.  The University of Colorado at Boulder makes no warranty
  about the suitability of this software for any purpose.  It is
  presented on an AS IS basis.]

  Revision    [$Id: mvfaig.h,v 1.7 2009/01/21 02:08:09 fabio Exp $]

******************************************************************************/

#ifndef _MVFAIG
#define _MVFAIG

/*---------------------------------------------------------------------------*/
/* Nested includes                                                           */
/*---------------------------------------------------------------------------*/
#include "maig.h"
#include "vm.h"

/*---------------------------------------------------------------------------*/
/* Constatn declarations                                                         */
/*---------------------------------------------------------------------------*/
#define MVFAIG_NETWORK_APPL_KEY "MvfAig_NetworkApplKey"

/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/
typedef array_t MvfAig_Function_t;


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/

/**Macro***********************************************************************

  Synopsis     [Iterates over the components of a multi-valued function.]

  Description [This macro iterates over the components of a multi-valued
  function.]

  SideEffects  [This macro instantiates macros from the array package.  Hence
  it is advisable not to nest this macro within array macros.]

  SeeAlso      [MvfAig_FunctionAlloc]

******************************************************************************/
#define MvfAig_FunctionForEachComponent(                                    \
  /* MvfAig_Function_t * */ function  /* function to iterate components */, \
  /* int                 */ i         /* local variable for iterator */,    \
  /* bAndInvEdge_t       */ component /* component of function */           \
)                                                                           \
  arrayForEachItem(bAigEdge_t, (array_t *) function, i, component)


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN void MvfAig_Init(void);
EXTERN void MvfAig_End(void);
EXTERN MvfAig_Function_t * MvfAig_FunctionAlloc(int n);
EXTERN void MvfAig_FunctionFree(MvfAig_Function_t *function);
EXTERN MvfAig_Function_t * MvfAig_FunctionDuplicate(MvfAig_Function_t *function);
EXTERN void MvfAig_FunctionArrayFree(array_t *functionArray);
EXTERN int MvfAig_FunctionReadNumComponents(MvfAig_Function_t *function);
EXTERN mAigEdge_t MvfAig_FunctionReadComponent(MvfAig_Function_t *function, int i);
EXTERN MvfAig_Function_t * MvfAig_FunctionCreateFromVariable(mAig_Manager_t *manager, mAigEdge_t mVarId);
EXTERN void MvfAig_FunctionAddMintermsToComponent(mAig_Manager_t *manager, MvfAig_Function_t *function, int i, mAigEdge_t g);
EXTERN mAigEdge_t MvfAig_FunctionsComputeEquivalentSet(mAig_Manager_t *manager, MvfAig_Function_t *function1, MvfAig_Function_t *function2);
EXTERN mAigEdge_t MvfAig_FunctionComputeDomain(mAig_Manager_t *manager, MvfAig_Function_t *function);


/**AutomaticEnd***************************************************************/


#endif /* _MVFAIG */

