/**CHeaderFile*****************************************************************

  FileName    [ordInt.h]

  PackageName [ord]

  Synopsis    [Internal declarations for the order package.]

  Author      [Adnan Aziz, Tom Shiple, Serdar Tasiran]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. of California.
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.]

  Revision    [$Id: ordInt.h,v 1.6 2004/07/28 19:50:49 wangc Exp $]

******************************************************************************/

#ifndef _ORDINT
#define _ORDINT

/*---------------------------------------------------------------------------*/
/* Nested includes                                                           */
/*---------------------------------------------------------------------------*/
#include "cmd.h"
#include "var.h"
#include "ord.h"

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/
#define ORDUNASSIGNED_DEPTH -1

#ifndef MAX
#  define MAX(a,b)              ((a) > (b) ? (a) : (b))
#endif

/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN int OrdNodesFromListCompareDepth(lsGeneric node1, lsGeneric node2);
EXTERN int OrdNodesFromArrayCompareDepth(const void * node1, const void * node2);
EXTERN void OrdNetworkComputeNodeDepths(Ntk_Network_t * network, lsList roots);
EXTERN void OrdNodeListWrite(FILE *fp, lsList nodeList);
EXTERN long OrdNodeReadDepth(Ntk_Node_t * node);
EXTERN void OrdNetworkAssignMddIds(Ntk_Network_t * network, Ord_OrderType orderType, lsList orderList, boolean nsAfterSupport);
EXTERN lsList OrdNetworkOrderTFIOfRoots(Ntk_Network_t *network, lsList roots, Ord_NodeMethod nodeOrderMethod, st_table *nodeToHandle, int verbose);
EXTERN lsList OrdNetworkOrderRootsByPerm(Ntk_Network_t *network, int verbose);
EXTERN lsList OrdNetworkOrderRootsByDepth(Ntk_Network_t *network, boolean verbose);
EXTERN void OrdNodeAddToList(lsList nodeList, st_table *nodeTable, Ntk_Node_t *node);
EXTERN int OrdMakeNewVariableOrder(mdd_manager *mddMgr, lsList suppliedNodeList, int group, int verbose);

/**AutomaticEnd***************************************************************/

#endif /* _ORDINT */



