/**CFile***********************************************************************

  FileName    [simSim.c]

  PackageName [sim]

  Synopsis    [Routines to manipulate simstructure.]

  Author      [Shaker Sarwary and Tom Shiple]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. of California.
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.]

******************************************************************************/
#include "simInt.h"

static char rcsid[] UNUSED = "$Id: simSim.c,v 1.2 1997/02/12 23:03:57 hsv Exp $";

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/

/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/


/**AutomaticEnd***************************************************************/


/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/

/**Function********************************************************************

  Synopsis    [Returns the network pointed by the sim structure.]

  Description [Returns the network pointed by the sim structure. It is an
  error to call this function with a NULL or a wrong sim structure. The user
  should not free the returned network.]

  SideEffects []

******************************************************************************/
Ntk_Network_t *
Sim_SimReadNetwork(
  Sim_Sim_t * sim)
{
  return (sim->network);
}
/**Function********************************************************************

  Synopsis    [Returns nodeToMvfTable of the sim structure.]

  Description [Returns nodeToMvfTable of the sim structure. It is an error to
  call this function with a NULL or wrong sim structure. The user should not
  change or free the returned structure.]

  SideEffects []

******************************************************************************/
st_table *
Sim_SimReadNodeToMvfTable(
  Sim_Sim_t * sim)
{
  return (sim->nodeToMvfTable);
}
/**Function********************************************************************

  Synopsis    [Returns the name of the input file of a sim.]

  Description [Returns the name of the input file of a sim. It is an error to
  call this function with a NULL or wrong sim structure. The user should not free
  the returned string.]

  SideEffects []

******************************************************************************/
char *
Sim_SimReadInputFile(
  Sim_Sim_t * sim)
{
  return (sim->inputFile);
}

/**Function********************************************************************

  Synopsis    [Returns the number of line already read by the parser in input file.]

  Description [Returns the number of line already read by the parser in input
  file. It is an error to call this function with a NULL or wrong sim structure.]

  SideEffects []

******************************************************************************/
int
Sim_SimReadLineNumber(
  Sim_Sim_t * sim)
{
  return (sim->lineNumber);
}

/**Function********************************************************************

  Synopsis    [Returns nodesArray of the sim structure.]

  Description [Returns nodesArray of the sim structure. It is an error to call
  this function with a NULL or wrong sim structure.]

  SideEffects []

******************************************************************************/
array_t *
Sim_SimReadNodesArray(
  Sim_Sim_t * sim)
{
  return (sim->nodesArray);
}

/**Function********************************************************************

  Synopsis    [Returns the index of the first current-state in nodesArray of
  the sim structure.]

  Description [Returns the index of the first current-state in nodesArray of
  the sim structure. It is an error to call this function with a NULL or wrong
  sim structure.]

  SideEffects []

******************************************************************************/
int
Sim_SimReadCurrentStateHead(
  Sim_Sim_t * sim)
{
  return (sim->currentStateHead);
}

/**Function********************************************************************

  Synopsis    [Returns the index of the first next-state in nodesArray of
  the sim structure.]

  Description [Returns the index of the first next-state in nodesArray of
  the sim structure. It is an error to call this function with a NULL or wrong
  sim structure.]

  SideEffects []

******************************************************************************/
int
Sim_SimReadNextStateHead(
  Sim_Sim_t * sim)
{
  return (sim->nextStateHead);
}

/**Function********************************************************************

  Synopsis [Returns the index of the first output in nodesArray of the sim
  structure.]

  Description [Returns the index of the first output in nodesArray of the sim
  structure. It is an error to call this function with a NULL or wrong sim
  structure.]

  SideEffects []

******************************************************************************/
int
Sim_SimReadOutputHead(
  Sim_Sim_t * sim)
{
  return (sim->outputHead);
}

/**Function********************************************************************

  Synopsis [Returns the initial state of the sim structure.]

  Description [Returns the initial state of the sim structure. It is an error
  to call this function with a NULL or wrong sim structure.]

  SideEffects []

******************************************************************************/
array_t *
Sim_SimReadInitState(
  Sim_Sim_t * sim)
{
  return (sim->initState);
}

/**Function********************************************************************

  Synopsis [Returns the array of simulation vectors of the sim structure.]

  Description [Returns the array of simulation vectors of the sim
  structure. It is an error to call this function with a NULL or wrong sim
  structure. The user should not free this array.]

  SideEffects []

******************************************************************************/
array_t *
Sim_SimReadVectorArray(
  Sim_Sim_t * sim)
{
  return (sim->vectorArray);
}

/**Function********************************************************************

  Synopsis [Returns 1 if verbose status of the sim structure is true.]

  Description [Returns 1 if verbose status of the sim structure is true. It is
  an error to call this function with a NULL or wrong sim structure.]

  SideEffects []

******************************************************************************/
boolean
Sim_SimTestIsVerbose(
  Sim_Sim_t * sim)
{
  return (sim->verbose);
}

























