/**CHeaderFile*****************************************************************

  FileName    [eqvInt.h]

  PackageName [eqv]

  Synopsis    []

  Description []

  SeeAlso     []

  Author      [Shaz Qadeer]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. of California.
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.]

  Revision    [$Id: eqvInt.h,v 1.3 2002/09/08 23:29:32 fabio Exp $]

******************************************************************************/

#ifndef _EQVINT
#define _EQVINT

#include "eqv.h"
#include <string.h>

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN st_table * MapPrimaryInputsByName(Ntk_Network_t *network1, Ntk_Network_t *network2);
EXTERN st_table * MapCombInputsByName(Ntk_Network_t *network1, Ntk_Network_t *network2);
EXTERN st_table * MapPrimaryOutputsByName(Ntk_Network_t *network1, Ntk_Network_t *network2);
EXTERN st_table * MapCombOutputsByName(Ntk_Network_t *network1, Ntk_Network_t *network2);
EXTERN OFT FindOrderingMethod(void);
EXTERN boolean TestRootsAndLeavesAreValid(Ntk_Network_t *network1, Ntk_Network_t *network2, st_table *inputMap, st_table *outputMap);
EXTERN st_table * MapNamesToNodes(Ntk_Network_t *network1, Ntk_Network_t *network2, st_table *names);
EXTERN int ReadRootLeafMap(FILE *inputFile, st_table *rootsTable, st_table *leavesTable);
EXTERN void DefaultCommonOrder(Ntk_Network_t *network1, Ntk_Network_t *network2, st_table *inputMap);
EXTERN boolean TestLeavesAreValid(Ntk_Network_t *network1, Ntk_Network_t *network2, st_table *leavesTable);
EXTERN boolean TestRootsAreValid(Ntk_Network_t *network1, Ntk_Network_t *network2, st_table *rootsTable);
EXTERN boolean TestPartitionIsValid(Ntk_Network_t *network, st_table *roots, st_table *leaves);

/**AutomaticEnd***************************************************************/

#endif /* _EQVINT */


















