%{
/**CFile***********************************************************************

  FileName    [io.y]

  PackageName [io]

  Synopsis    [Yacc file for the BLIF-MV parser.]

  Description []

  SeeAlso     []

  Author      [Yuji Kukimoto, Rajeev Ranjan, Huey-Yih Wang]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. of California.
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.]

******************************************************************************/

#include "ioInt.h"

/*
 * The following is a workaround for a bug in bison, which generates code
 * that uses alloca().  Their lengthy sequence of #ifdefs for defining
 * alloca() does the wrong thing for HPUX (it should do what is defined below)
 */
#ifdef __hpux
#  include <alloca.h>
#endif
 
static char rcsid[] UNUSED = "$Id: io.y,v 1.11 2010/04/09 23:32:13 fabio Exp $";

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Stucture declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/
int globalLineNumber;
Hrc_Manager_t *globalYaccHmgr;
Hrc_Model_t *globalModel;
Hrc_Node_t *globalHnode;
Hrc_Model_t *globalFirstModel;
Hrc_Model_t *globalRootModel;
char *globalRootInstanceName;
array_t *globalMvNameArray;
array_t *globalSymValueArray;
array_t *globalTableInputArray;
array_t *globalTableOutputArray;
array_t *globalTableDefaultArray;
array_t *globalTableSymCubeArray;
array_t *globalFormalNameArray;
array_t *globalActualNameArray;
array_t *globalSubcktArray;
array_t *globalResetArray;
st_table *globalParserResetInfo;
st_table *globalParserSubcktInfo;
array_t *globalNewModelArray;

/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/

/**AutomaticEnd***************************************************************/


/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Definition of internal functions                                          */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Definition of static functions                                            */
/*---------------------------------------------------------------------------*/

#include "ioLex.c"

static void
IoYyerror(char *string)
{
  (void)fprintf(vis_stderr,"%s",error_string());
  (void)fprintf(vis_stderr,"%s in line %d with token %s\n",string,globalLineNumber,IoYytext);
  fflush(vis_stderr);
}

%}

/* %token YYERROR_VERBOSE */

%token MODEL END INPUTS OUTPUTS MV LATCH RESET NAMES DEFAULT SUBCKT ROOT
%token IDENTIFIER ARROW ASSIGN NEWLINE

%union {
  char *string;
  int integer;
  IoSymValue_t *IoSymValue_t_ptr;
  array_t *array_t_ptr;
}

%type <string> name;
%type <integer> range;
%type <IoSymValue_t_ptr> sym_value sym_value_without_assign basic_sym_value;
%type <array_t_ptr> sub_sym_value;

%start models

%%

models:
	  model
	| models model
	| models error {
		IoError();
	  }
	;
model:
	  model_start model_content model_end 
	;
model_start:
	  MODEL name NEWLINE {
	  if ( Hrc_ManagerFindModelByName(globalYaccHmgr,$2) ){
	    error_append("Model ");
	    error_append($2);
	    error_append(" is multiply-defined\n");
	    FREE($2);
	    IoError();
	  } 
	  globalModel = Hrc_ModelAlloc(globalYaccHmgr,$2); 
	  globalHnode = Hrc_ModelReadMasterNode(globalModel);
	  if ( globalFirstModel == NIL(Hrc_Model_t) )
	    globalFirstModel = globalModel;
	  FREE($2);
          array_insert_last(Hrc_Model_t *,globalNewModelArray,globalModel);
	  }
	  option_root
	;
option_root:
	  /* empty */
	| ROOT NEWLINE {
	  if ( globalRootModel != NIL(Hrc_Model_t) ){
	    error_append("Two models ");
	    error_append(Hrc_ModelReadName(globalRootModel));
	    error_append(" and ");
	    error_append(Hrc_ModelReadName(globalModel));
	    error_append(" are defined as the root model\n");
            IoError();
	  }
	  globalRootModel = globalModel;
	  }	
	| ROOT name NEWLINE {
	  if ( globalRootModel != NIL(Hrc_Model_t) ){
	    error_append("Two models ");
	    error_append(Hrc_ModelReadName(globalRootModel));
	    error_append(" and ");
	    error_append(Hrc_ModelReadName(globalModel));
	    error_append(" are defined as the root model\n");
            IoError();
	  }
	  globalRootModel = globalModel;
	  globalRootInstanceName = $2;
	  }	
	;
model_end:
	  END NEWLINE {
	  if (st_is_member(globalParserResetInfo,(char *)globalModel) == 1){
	    error_append("Model ");
	    error_append(Hrc_ModelReadName(globalModel));
	    error_append(" is multiply-defined.\n");
            IoError();
	  }
	  /* the following st_insert should return 0 */
	  (void)st_insert(globalParserResetInfo,(char *)globalModel,(char *)globalResetArray);
	  if (st_is_member(globalParserSubcktInfo,(char *)globalModel) == 1){
	    error_append("Model ");
	    error_append(Hrc_ModelReadName(globalModel));
	    error_append(" is multiply-defined.\n");
	    IoError();
	  }
	  /* the following st_insert should return 0 */
	  (void)st_insert(globalParserSubcktInfo,(char *)globalModel,(char *)globalSubcktArray);
	  globalResetArray = NIL(array_t);
	  globalSubcktArray = NIL(array_t);
	  globalModel = NIL(Hrc_Model_t);
	  globalHnode = NIL(Hrc_Node_t);
	  }
	;
model_content:
	  /* empty */
	| model_content command
	;
command:
	  input
	| output
	| mv
	| latch
	| table
	| reset
	| subckt
	;
input:
	  INPUTS input_names NEWLINE
	;
input_names:
	  /* empty */
	| input_names input_name
	;
input_name:
	  name {
	  if (IoInputProcess(globalHnode,$1) == 0){
	    error_append("Input ");
	    error_append($1);
	    error_append(" is multiply defined.\n");
	    FREE($1);
            IoError();
	  }
	  FREE($1);
	  }
	;
output:
	  OUTPUTS output_names NEWLINE
	;
output_names:
	  /* empty */
	| output_names output_name
	;
output_name:
	  name {
	  if (IoOutputProcess(globalHnode,$1) == 0){
	    error_append("Output ");
	    error_append($1);
	    error_append(" is multiply defined.\n");
	    FREE($1);
            IoError();
	  }
	  FREE($1);
	  }
	;
mv:
	  MV mv_names range NEWLINE {
	  if (IoMvProcess(globalModel,globalHnode,globalMvNameArray,$3,NIL(array_t)) == 0){
            IoStringArrayFree(globalMvNameArray);
            IoError();
	  }
          IoStringArrayFree(globalMvNameArray);
          globalMvNameArray = NIL(array_t);
	  }
	| MV mv_names range val_names NEWLINE {
          if (IoMvProcess(globalModel,globalHnode,globalMvNameArray,$3,globalSymValueArray) == 0){
            IoStringArrayFree(globalMvNameArray);
            IoStringArrayFree(globalSymValueArray);
            IoError();
          }
          IoStringArrayFree(globalMvNameArray);
          IoStringArrayFree(globalSymValueArray);
          globalMvNameArray = NIL(array_t);
          globalSymValueArray = NIL(array_t);
	  }
	;
mv_names:
	  mv_name
	| mv_names ',' mv_name 
	;
mv_name:
	  name {
	  IoNameInsertInArray(&globalMvNameArray,$1);
	  }
	;
range:
	  name {
	  $$ = IoAtoi($1);
          FREE($1);
	  }
	;
val_names:
	  val_name
	| val_names val_name
	;
val_name:
	  name {
	  IoNameInsertInArray(&globalSymValueArray,$1);
	  }
	;
latch:
	  LATCH name name NEWLINE {
	  if (IoLatchProcess(globalModel,globalHnode,$2,$3) == 0){
	    IoError();
	    FREE($2);
	    FREE($3);
          }
	  FREE($2);
	  FREE($3);
	  }
	;


reset:
	  RESET table_io_names NEWLINE option_default table_content {
	  if (IoResetProcess(&globalResetArray,globalModel,globalHnode,globalTableInputArray,globalTableOutputArray,globalTableDefaultArray,globalTableSymCubeArray) == 0){
	    IoError();
	  }
	  globalTableInputArray = NIL(array_t);
	  globalTableOutputArray = NIL(array_t);
	  globalTableDefaultArray = NIL(array_t);
	  globalTableSymCubeArray = NIL(array_t);
	  }
	;
table:
	  NAMES table_io_names NEWLINE option_default table_content {
	  if (IoTableProcess(globalModel,globalHnode, globalTableInputArray,globalTableOutputArray,globalTableDefaultArray,globalTableSymCubeArray) == 0){
	    IoError();
	  }
	  globalTableInputArray = NIL(array_t);
          globalTableOutputArray = NIL(array_t);
          globalTableDefaultArray = NIL(array_t);
          globalTableSymCubeArray = NIL(array_t);
	  }
	;
table_io_names:
	  table_input_names ARROW table_output_names
	| table_input_names table_output_name
	;
table_input_names:
	  /* empty */
	| table_input_names table_input_name
	;
table_input_name:
	  name {
	  IoNameInsertInArray(&globalTableInputArray,$1);
	  }
	;
table_output_names:
	  table_output_name
	| table_output_names table_output_name
	;
table_output_name:
	  name {
	  IoNameInsertInArray(&globalTableOutputArray,$1);
	  }
	;
option_default:
	  /* empty */
	| DEFAULT def_values NEWLINE 
	; 
def_values:
	  def_value
	| def_values def_value
	;
def_value:
	  sym_value {
	  IoSymValueInsertInArray(&globalTableDefaultArray,$1);
	  }
	; 
sym_values:
	  sym_value {
	  IoSymValueInsertInArray(&globalSymValueArray,$1);
	  }
	| sym_values sym_value {
	  IoSymValueInsertInArray(&globalSymValueArray,$2);
	  }
	;
sym_value:
	  basic_sym_value 
	| ASSIGN name {
	  IoSymValue_t *entry;
	  entry = IoSymValueAlloc();
	  entry->left = (IoSymValue_t *)$2;
	  entry->flag = IoAssign_c;
	  $$ = entry;
	  }
	| '(' sub_sym_value ')' {
	  IoSymValue_t *entry;
	  entry = IoSymValueAlloc();
	  entry->elements = $2;
	  entry->flag = IoList_c;
	  $$ = entry;
	  }
	| '!' sym_value_without_assign {
	  IoSymValue_t *entry;
	  entry = IoSymValueAlloc();
	  entry->left = $2;
	  entry->flag = IoComplement_c;
	  $$ = entry;
	  }
	;
sym_value_without_assign:
	  basic_sym_value 
	| '(' sub_sym_value ')' {
	  IoSymValue_t *entry;
	  entry = IoSymValueAlloc();
	  entry->elements = $2;
	  entry->flag = IoList_c;
	  $$ = entry;
	  }
	| '!' sym_value_without_assign {
	  IoSymValue_t *entry;
	  entry = IoSymValueAlloc();
	  entry->left = $2;
	  entry->flag = IoComplement_c;
	  $$ = entry;
	  }
	;
basic_sym_value:
	  '-' {
	  IoSymValue_t *entry;
          entry = IoSymValueAlloc();
          entry->flag = IoUniverse_c;
          $$ = entry;
	  }
	| name {
	  IoSymValue_t *entry;
	  entry = IoSymValueAlloc();
	  entry->flag = IoLeaf_c;
	  entry->left = (IoSymValue_t *)$1;
	  $$ = entry;
	  }
	| '{' name '-' name '}' {
	  IoSymValue_t *entry;
	  entry = IoSymValueAlloc();
	  entry->left = (IoSymValue_t *)$2;
	  entry->right = (IoSymValue_t *)$4;
	  entry->flag = IoRange_c;
	  $$ = entry;
	  }
	;
sub_sym_value:
	  sym_value_without_assign {
	  array_t *array;
	  array = array_alloc(IoSymValue_t *,0);
	  array_insert_last(IoSymValue_t *,array,$1);
	  $$ = array; 
	  }
	| sub_sym_value ',' sym_value_without_assign {
	  array_insert_last(IoSymValue_t *,$1,$3);
	  }
	;
table_content: /* must have at least one row */
          /* empty */
	/*
	  sym_values NEWLINE {
	  IoSymCubeInsertInArray(&globalTableSymCubeArray,globalSymValueArray);	  
	  globalSymValueArray = NIL(array_t);
	  }
	*/
	| table_content sym_values NEWLINE {
	  IoSymCubeInsertInArray(&globalTableSymCubeArray,globalSymValueArray);	  
	  globalSymValueArray = NIL(array_t);
	  }
	;

subckt:
	  SUBCKT name name connections NEWLINE {
          if (IoSubcktProcess(&globalSubcktArray,globalModel,globalHnode,$2,$3,globalFormalNameArray,globalActualNameArray) == 0 ){
            IoError();
	  }
	  globalFormalNameArray = NIL(array_t);
	  globalActualNameArray = NIL(array_t);
	  }
	;
connections:
	  connection
	| connections connection
	;
connection:
	  name ASSIGN name {
	  IoNameInsertInArray(&globalFormalNameArray,$1);
	  IoNameInsertInArray(&globalActualNameArray,$3);
	  }	
	;  
name:
	  IDENTIFIER {
	  $$ = util_strsav(IoYytext);	
	  }
	;

%%

