/**CHeaderFile*****************************************************************

  FileName    [rst.h]

  PackageName [rst]

  Synopsis    [Restructuring package for restructuring the hierarchy]

  Description [This package provides the capability to restructure the user's
               hierarchy. Currently only collapsing adjacent nodes is
               provided. Parititioning FSMs is expected to be provided in the
               future] 

  Author      [Desmond A. Kirkpatrick and Sriram Rajamani (with many thanks to Yuji Kukimoto)]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. of California.
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.]


******************************************************************************/

#ifndef _RST
#define _RST

/*---------------------------------------------------------------------------*/
/* Nested includes                                                           */
/*---------------------------------------------------------------------------*/
#include "hrc.h"
/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN void Rst_Init(void);
EXTERN void Rst_End(void);
EXTERN array_t* Rst_VartoVarLookup(array_t* VarArray, st_table* VartoVarOne, st_table* VartoVarTwo);
EXTERN array_t* Rst_GetNamesUntilNextOption(array_t* nameArray, int argc, char **argv);
EXTERN array_t* Rst_LoadNameArrayFromFile(array_t* nameArray, FILE* fp);
EXTERN Hrc_Model_t* Rst_GroupRestructureModel(Hrc_Manager_t* Hmgr, Hrc_Model_t* ParentModel, array_t* GroupArray);
EXTERN Hrc_Node_t* Rst_GroupRestructureNode(Hrc_Manager_t* Hmgr, Hrc_Node_t* CurNode, array_t* GroupArray);
EXTERN Hrc_Model_t* Rst_GroupGroupCombLogic(Hrc_Manager_t* Hmgr, Hrc_Model_t* CurModel);
EXTERN Hrc_Model_t* Rst_GroupGroupLatches(Hrc_Manager_t* Hmgr, Hrc_Model_t* CurModel);
EXTERN int Rst_CommandGroupComponents(Hrc_Manager_t** Hmgr, int argc, char ** argv);

/**AutomaticEnd***************************************************************/

#endif /* _RST */
