/**CHeaderFile*****************************************************************

  FileName    [rstInt.h]

  PackageName [rst]

  Synopsis    [Internal declarations.]

  Author      [Sriram Rajamani (with many thanks to Yuji Kukimoto)]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. of California.
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.]

******************************************************************************/

#ifndef _RSTINT
#define _RSTINT

/*---------------------------------------------------------------------------*/
/* Nested includes                                                           */
/*---------------------------------------------------------------------------*/
#include "rst.h"
#include "cmd.h"
#include <string.h>

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/

typedef struct Rst_Group {
  st_table *Vars,               /* Non-input Variables assigned to group */
    *Subcircuits,               /* Subcircuits assigned / have group outputs */
    *Latches,                   /* Latch output must be in group */
    *Tables,                    /* Table output(s) must be in group */
    *Inputs,                    /* Derived Inputs*/
    *Outputs,                   /* Derived Outputs */
    *VarBackPtr;                /* Table to original vars */
  char* name;                   /* New model/instance name */
} Rst_Group_t;


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN int RstCollapseNode(Hrc_Manager_t *hmgr, Hrc_Node_t *parent, Hrc_Node_t *child);
EXTERN st_table * RstAddChildComponentsToNewModel(Hrc_Manager_t *hmgr, Hrc_Node_t *child, Hrc_Node_t *parent, Hrc_Model_t *newModelPtr);
EXTERN int RstAddParentComponentsToNewModel(Hrc_Manager_t *hmgr, Hrc_Node_t *parent, Hrc_Model_t *newModelPtr, st_table *parentVarTable, Hrc_Node_t *child);
EXTERN void Var_VariableResetNumFanout(Var_Variable_t* var);
EXTERN Tbl_Table_t* Tbl_TableDupAndSubstVars(Tbl_Table_t* Table, st_table* VartoVar);
EXTERN Rst_Group_t* RstGroupComponents(Hrc_Model_t* CurModel, char* NewName, array_t* VarGroup, array_t* Subcircuits);
EXTERN Rst_Group_t* RstGroupAlloc(char* Name);
EXTERN void RstGroupFree(Rst_Group_t* Group);
EXTERN char* RstGroupNewParentName(char* Name);
EXTERN void RstGroupPrint(Rst_Group_t* group);
EXTERN int RstGroupDisjointCheck(array_t* GroupArray);
EXTERN Rst_Group_t* RstCreateParentGroup(Hrc_Manager_t* Hmgr, Hrc_Model_t* ParentModel, char* NewModelName, array_t* GroupArray);
EXTERN void RstModelPrint(Hrc_Model_t* newModel);
EXTERN Hrc_Model_t* RstGroupBuildModel(Hrc_Manager_t* Hmgr, Rst_Group_t* Group);

/**AutomaticEnd***************************************************************/

#endif /* _RSTINT */


