/**CHeaderFile*****************************************************************

  FileName    [simInt.h]

  PackageName [sim]

  Synopsis    [sim package internal declarations file.]
  
  Author      [Shaker Sarwary and Tom Shiple]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. of California.
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.]

  Revision    [$Id: simInt.h,v 1.4 2005/05/10 15:50:43 hhkim Exp $]

******************************************************************************/

#ifndef _SIMINT
#define _SIMINT

/*---------------------------------------------------------------------------*/
/* Nested includes                                                           */
/*---------------------------------------------------------------------------*/
#include "cmd.h"
#include "ntm.h"
#include "ord.h"
#include "part.h"
#include "sim.h"
#include <string.h>

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/
#define SIMPACKET_SIZE    1000

/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/

/**Struct**********************************************************************

  Synopsis    [SIM main structure.]

******************************************************************************/

struct SimSimStruct {
  Ntk_Network_t *network;          /* Pointer to the network */
  st_table      *nodeToMvfTable;   /* MDDs of functions to be simulated */
  char          *inputFile;        /* simulation file name */
  int            lineNumber;       /* Current line parsed in InputFile */
  array_t       *nodesArray;       /* Ordered nodes corresponding to the inputs,
                                      current-states, next-states and outputs */
  int            currentStateHead; /* Position of the first currentState in nodesArray */
  int            internalPartitionHead; /* Position of the first internal partition node 
                                        in nodesArray */
  int            nextStateHead;    /* Position of the first nextState in nodesArray */
  int            outputHead;       /* Position of the first output in nodesArray */
  array_t       *initState;        /* Initial state */
  array_t       *vectorArray;      /* Array of array representing the
                                      simulation vectors according to the
                                      nodesArray order */
  boolean        verbose;
};
  
  
/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN void SimSimInitializeCurrentState(Sim_Sim_t * sim);
EXTERN boolean SimRandomSimulateAndPrint(Ntk_Network_t * network, int num, char * outputFile, Sim_PseudoSrc pseudoInputSource, int printInputsFlag, int printOutputsFlag, int printPseudoInputsFlag, int printStatesFlag, boolean verbose);
EXTERN boolean SimFileSimulateAndPrint(Ntk_Network_t * network, int num, char * inputFile, char * outputFile, Sim_PseudoSrc pseudoInputSource, int printInputsFlag, int printOutputsFlag, int printPseudoInputsFlag, int printStatesFlag, boolean verbose);
EXTERN int SimNodeReadValueCode(Ntk_Node_t * node, char * value);
EXTERN boolean SimTestPartInTermsOfCI(Sim_Sim_t *sim);
EXTERN char * SimInteger2ASCII(int number);
EXTERN void SimStringPrint(FILE * fp, char * string, int len);
EXTERN array_t * SimSimInitDataFormat(Sim_Sim_t * sim);
EXTERN void SimSimVectorFillCurrentState(Sim_Sim_t * sim, int n);
EXTERN int SimNodeComputeRandomValue(Ntk_Node_t * node, Sim_PseudoSrc pseudoInputSource);
EXTERN mdd_t * SimSimVectorBuildMdd(Sim_Sim_t * sim, array_t * vector, array_t * partitionVector);
EXTERN void SimAppendErrorMsg(char * str1, char * str2, char * str3);
EXTERN int SimComputeRandomInteger(void);
EXTERN void SimNodesArrayBuildRootsAndLeaves(Ntk_Network_t *network, array_t * nodesArray, int internalPartitionHead, int nextStateHead, array_t ** roots, array_t ** leaves);
EXTERN st_table * SimNodesArrayBuildNodeToMvfTable(array_t * nodesArray, int internalPartitionHead, array_t * mvfArray);

/**AutomaticEnd***************************************************************/

#endif /* _SIMINT */






























































































