/**CHeaderFile*****************************************************************

  FileName    [spfd.h]

  PackageName [spfd]

  Synopsis [SPFD-based wire removal and replacement algorithm for
  logic optimization of combinational circuits mapped to FPGAs.]

  Description [This package implements wire removal and replacement
  based logic optimization for combinational circuits mapped to
  FPGAs. SPFDs (see the reference below) are used to represent
  flexibilities in the Boolean network. This package provides two
  commands: (1) spfd_pilo, a placement independent logic optimization
  technique.  2. spfd_pdlo: A combined logic and placement
  optimization technique. spfd_pdlo requires the package 
  <a href="http://www.eecg.toronto.edu/~vaughn/vpr/vpr.html">VPR</a>.
  Please contact Balakrishna Kumthekar at kumtheka@avanticorp.com to
  obtaining a patch for VPR to work with VIS.

  <p>
  S. Yamashita, H. Sawada, and A. Nagoya. A new method to express
  functional permissibilities for LUT based FPGAs and its
  applications. In International Conference on Computer Aided Design,
  pages 254-261, 1996.

  <p>
  Subarnarekha Sinha and Robert K. Brayton. Implementation and use of
  SPFDs in optimizaing Boolean networks. In International Conference
  on Computer Aided Design, 1998.

  <p>
  Balakrishna Kumthekar and Fabio Somenzi. Power and delay reduction
  via simultaneous logic and placement optimization in FPGAs.
  In Design, Automation and Test in Europe, 2000.]

  SeeAlso     [spfdInt.h]

  Author      [Balakrishna Kumthekar]

  Copyright   [This file was created at the University of Colorado at Boulder.
  The University of Colorado at Boulder makes no warranty about the suitability
  of this software for any purpose.  It is presented on an AS IS basis.]

******************************************************************************/

#ifndef _SPFD
#define _SPFD

#include "vm.h"

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN void Spfd_Init(void);
EXTERN void Spfd_End(void);

/**AutomaticEnd***************************************************************/

#endif /* _SPFD */
