/**CHeaderFile*****************************************************************

  FileName    [ioInt.h]

  PackageName [io]

  Synopsis    [Internal declarations of the I/O package.]

  Description []

  SeeAlso     []

  Author      [Yuji Kukimoto, Sunil P. Khatri, Rajeev Ranjan, Huey-Yih Wang]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. of California.
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.]

  Revision    [$Id: ioInt.h,v 1.10 2004/07/16 00:05:26 wangc Exp $]

******************************************************************************/

#ifndef _IOINT
#define _IOINT

#include "var.h"
#include "tbl.h"
#include "io.h"
#include "cmd.h"
#include "ord.h"
#include "ntk.h"
#include "ntm.h"
#include <string.h>

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/

typedef struct IoSymValueStruct IoSymValue_t;
typedef struct IoParsedTableStruct IoPTable_t;
typedef struct IoSubcktStruct IoSubckt_t;
typedef struct IoBlifInfoStruct IoBlifInfo_t;
typedef struct IoVarEncEntryStruct IoVarEncEntry_t;
typedef struct IoBinRangeEntryStruct IoBinRangeEntry_t;

/*---------------------------------------------------------------------------*/
/* Stucture declarations                                                     */
/*---------------------------------------------------------------------------*/

/**Enum************************************************************************

  Synopsis    [Types of a node in the tree data structure for a table.]

  Description []

  SeeAlso     []

******************************************************************************/
typedef enum {
  IoLeaf_c,
  IoRange_c,
  IoComplement_c,
  IoList_c,
  IoAssign_c,
  IoUniverse_c
} IoSymValueType;


/**Struct**********************************************************************

  Synopsis    [A tree representation of a table. This structure is used
  to represent a node in the tree. The parser translates 
  tables represented in IoParsedTable_t to this data structure so that
  it is easy to construct the table data structure Tbl_Table_t
  corresponding to the table.]

  Description []

  SeeAlso     []

******************************************************************************/
struct IoSymValueStruct {
  IoSymValueType flag;
  struct IoSymValueStruct *left;
  struct IoSymValueStruct *right;
  array_t *elements;	/* array_t of SymValueStruct * */
};

/**Struct**********************************************************************

  Synopsis    [A temporary data structure to keep the textual information
  on tables. Only used in the parser. ]

  Description []

  SeeAlso     []

******************************************************************************/
struct IoParsedTableStruct {
  array_t *inputs;  /* array of table input names */
  array_t *outputs;  /* array of table output names */
  array_t *cubes; /* array of array_t *, each array_t is a symCube */
  array_t *defaultOutput; /* this field is a single symCube */
};


/**Struct**********************************************************************

  Synopsis    [A temporary data structure to keep the textual information
  on subcircuits. Only used in the parser.]

  Description []

  SeeAlso     []

******************************************************************************/
struct IoSubcktStruct {
  char *modelName;
  char *instanceName;
  array_t *formalNameArray;
  array_t *actualNameArray;
};

/**Struct**********************************************************************

  Synopsis    [info for write blif]

  Description []

  SeeAlso     []

******************************************************************************/
struct IoBlifInfoStruct {
  Tbl_Table_t *blifmvTable;
  Tbl_Table_t *binTable;
  array_t *inputEncTblArray;
  array_t *outputEncTblArray;
  array_t *varArray;
  array_t *binTblArray;
  array_t *dcTblArray;
  int verbosity;
  boolean pseudoinputFlag;
  FILE *EncFp;
  FILE *BlifFp;
};

/**Struct**********************************************************************

  Synopsis    [Binary ranges structure, for binary entries compaction 
               in write_blif ]

  Description []

  SeeAlso     []

******************************************************************************/
struct IoBinRangeEntryStruct {
    int startValue;
    int runLength;
    int skipLength;
};

/**Struct**********************************************************************

  Synopsis    [info for encoding variablen]

  Description []

  SeeAlso     []

******************************************************************************/
struct IoVarEncEntryStruct {
    Var_Variable_t *variable;
    int index;
    int numEncBits;
};

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/

extern int globalLineNumber;
extern Hrc_Manager_t *globalYaccHmgr;
extern Hrc_Model_t *globalModel;
extern Hrc_Node_t *globalHnode;
extern Hrc_Model_t *globalFirstModel;
extern Hrc_Model_t *globalRootModel;
extern char *globalRootInstanceName;
extern array_t *globalMvNameArray;
extern array_t *globalSymValueArray;
extern array_t *globalTableInputArray;
extern array_t *globalTableOutputArray;
extern array_t *globalTableDefaultArray;
extern array_t *globalTableSymCubeArray;
extern array_t *globalFormalNameArray;
extern array_t *globalActualNameArray;
extern array_t *globalSubcktArray;
extern array_t *globalResetArray;
extern array_t *globalNewModelArray;
extern st_table *globalParserResetInfo;
extern st_table *globalParserSubcktInfo;


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN boolean IoNetworkTestConsistency(Hrc_Manager_t *hmgr, array_t *modelArray, st_table *parserSubcktInfo, st_table *parserResetInfo, boolean isVerbose);
EXTERN Var_Variable_t * IoVariableFindOrAllocByName(Hrc_Node_t *hnode, char *name);
EXTERN int IoAtoi(char *string);
EXTERN void IoStringArrayFree(array_t *array);
EXTERN void IoNameInsertInArray(array_t **arrayPtrPtr, char *name);
EXTERN void IoSymValueInsertInArray(array_t **arrayPtrPtr, IoSymValue_t *value);
EXTERN void IoSymCubeInsertInArray(array_t **arrayPtrPtr, array_t *symCube);
EXTERN boolean IoInputProcess(Hrc_Node_t *hnode, char *name);
EXTERN boolean IoOutputProcess(Hrc_Node_t *hnode, char *name);
EXTERN boolean IoMvProcess(Hrc_Model_t *model, Hrc_Node_t *hnode, array_t *varNames, int range, array_t *symValues);
EXTERN boolean IoLatchProcess(Hrc_Model_t *model, Hrc_Node_t *hnode, char *latchInput, char *latchOutput);
EXTERN boolean IoTableProcess(Hrc_Model_t *model, Hrc_Node_t *hnode, array_t *inputArray, array_t *outputArray, array_t *defaultArray, array_t *symCubeArray);
EXTERN boolean IoResetProcess(array_t **resetArray, Hrc_Model_t *model, Hrc_Node_t *hnode, array_t *inputArray, array_t *outputArray, array_t *defaultArray, array_t *symCubeArray);
EXTERN boolean IoSubcktProcess(array_t **subcktArray, Hrc_Model_t *model, Hrc_Node_t *hnode, char *modelName, char *instanceName, array_t *formalNameArray, array_t *actualNameArray);
EXTERN void IoError(void);
EXTERN boolean _IoNodeTestCompatibility(Hrc_Manager_t *hmgr, Hrc_Node_t *hnode1, Hrc_Node_t *hnode2);
EXTERN Tbl_Table_t * IoPTableTransformToTable(Hrc_Model_t *model, Hrc_Node_t *hnode, IoPTable_t *pTable);
EXTERN IoSymValue_t * IoSymValueAlloc(void);
EXTERN void IoSymValueArrayFree(array_t *valueArray);
EXTERN void IoBlifMvWrite(FILE *fp, Hrc_Manager_t *hmgr);
EXTERN void IoMvPrint(FILE *fp, Var_Variable_t *var);
EXTERN void IoMvPrintSpecial(FILE *fp, Var_Variable_t *var);
EXTERN void IoSmvWrite(FILE *fp, Hrc_Manager_t *hmgr);
EXTERN void IoSmvPrint(FILE *fp, Var_Variable_t *var);
EXTERN void IoSmvPrintSpecial(FILE *fp, Var_Variable_t *var);
EXTERN IoVarEncEntry_t *IoFindSmallestCode(IoBlifInfo_t *blifInfo);
EXTERN array_t *IoMakeBinaryRangesArray(Tbl_Entry_t *entry, int colnum, IoBlifInfo_t *blifInfo);
EXTERN Tbl_Table_t *IoMakeSingleOutputTable(Tbl_Table_t *table, int i);
EXTERN int IoBlifWriteInputs(Hrc_Node_t *hnode, FILE *fp, st_table *blifInputsStTable, int combinationalOnly, int makeLatchIOsPOs);
EXTERN int IoBlifWriteOutputs(Hrc_Node_t *hnode, FILE *fp, st_table *blifOutputsStTable, int combinationalOnly, int makeLatchIOsPOs);
EXTERN void IoChangeBlifmvTableRows(IoBlifInfo_t *blifInfo, IoVarEncEntry_t *varEnc, int row1, int row2);
EXTERN void IoChangeBlifmvTableEntries(IoBlifInfo_t *blifInfo, int rownum, int numValues, IoVarEncEntry_t *varEnc, array_t *MvOutputArray);
EXTERN void IoChangeEncTableEntries(IoBlifInfo_t *blifInfo, st_table *blifInputsStTable, IoVarEncEntry_t *varEnc, int numValues);
EXTERN void IoEncWriteBinToMvTables(Hrc_Node_t *hnode, FILE *encFp, st_table *encOutputsStTable, st_table *encInputsStTable, int combinationalOnly, int makeLatchIOsPOs);
EXTERN void IoEncWriteMvToBinTables(Hrc_Node_t *hnode, FILE *encFp, st_table *encOutputsStTable, st_table *encInputsStTable, int combinationalOnly);
EXTERN void IoEncodeVariable(IoBlifInfo_t *blifInfo, Var_Variable_t *var, int varNum, int output);
EXTERN void IoFreeBlifInfo(IoBlifInfo_t *blifInfo);
EXTERN void IoIncreaseCodeSize(IoVarEncEntry_t *varEnc, int numValues, int verbosity);
EXTERN void IoInitBlifInfo(IoBlifInfo_t *blifInfo, Tbl_Table_t *origBlifmvTable, FILE *fp, FILE *encFp, int verbosity);
EXTERN void IoInvertBinTableOutput(IoBlifInfo_t * blifInfo, int colnumToInvert);
EXTERN int IoLog(int n);
EXTERN void IoMvCheckPrint(FILE *fp, Var_Variable_t *var, st_table *printedMvsStTable);
EXTERN void IoMvCheckPrintSpecial(FILE *fp, Var_Variable_t *var, st_table *printedMvsStTable);
EXTERN int IoNumBinVars(int colnum, array_t *encTblArray);
EXTERN int IoNumDigits(int n);
EXTERN int IoNumEncBits(int n);
EXTERN int IoNumValuesFromBinRangesArray(int colnum, array_t *binRangesArray);
EXTERN boolean IoOutputExpansionRequired(Tbl_Table_t *table);
EXTERN boolean IoVarIsHnodePIO(Hrc_Node_t *hnode, Var_Variable_t *var);
EXTERN void IoWriteBinTablesToFile(IoBlifInfo_t *blifInfo);
EXTERN int IoWriteExpandedValueToBinTable(Tbl_Table_t *binTable, int rootRow, int rootCol, IoBinRangeEntry_t *binRangeEntry, int entryRepetitionCount, int numBits, int output);
EXTERN void IoWriteLatches(Hrc_Node_t *hnode, FILE *fp, FILE *encFp, st_table *printedMvsStTable, st_table *blifOutputsStTable, st_table *blifInputsStTable, st_table *encOutputsStTable, st_table *encInputsStTable, int combinationalOnly, int makeLatchIOsPOs, int verbosity);


/**AutomaticEnd***************************************************************/

EXTERN int IoYyparse(void);
EXTERN void IoYyrestart(FILE *);

#endif /* _ */














































































