/**CHeaderFile*****************************************************************

  FileName    [rtInt.h]

  PackageName [rt]

  Synopsis    [Internal declarations.]

  Author      [HoonSang Jin]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. of California.
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.]

  Revision    [$Id: rtInt.h,v 1.4 2002/09/19 21:44:06 jinh Exp $]

******************************************************************************/

#ifndef _RTINT
#define _RTINT

/*---------------------------------------------------------------------------*/
/* Nested includes                                                           */
/*---------------------------------------------------------------------------*/
#include "rt.h"
#include <string.h>


/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/
struct RtConfig {
  char *configurationFile;
  char *designDirectory;
  char *referenceVis;
  char *referenceVisNickName;
  char *referenceVisOptionFile;
  char *referenceOutDirectory;
  int  bRefRun;
  char *newVis;
  char *newVisNickName;
  char *newVisOptionFile;
  char *newOutDirectory;
  int  bNewRun;
  char *refCommandTemplate;
  char *newCommandTemplate;
  char *designList;
  int bRefOnly;
  int bCompareCounterExample;
  int bFinalResultOnly;
  int bDefaultInitCommand;
  int bDontRemoveTempFile;
  char *resultForCounterExample;
  char *resultForPerformance;
  char *scriptFile;
  array_t *compareItemArr;
  array_t *designListArr;
  array_t *refCommandTemplateArr;
  array_t *newCommandTemplateArr;
  st_table *keyWordTable;
};

struct RtDesignList {
  char *designDirectory;
  char *designNickName;
  char *blifFile;
  char *ctlFile;
  char *invFile;
  char *leFile;
  char *fairFile;
  char *hintFile;
  char *ordFile;
  char *ltlFile;
  int coreDumped;
  int refRunFail;
  int newRunFail;
  int bIsMv;
  array_t *resultForCommandArr1;
  array_t *resultForCommandArr2;
};

struct RtCommandResult {
  char *command;
  int error;
  array_t *compareItemArr;
  array_t *resultForProperty;
  int  bTimeOut;
};

struct RtCompareItem {
  char *itemName;
  char *itemNickName;
  char *value;
};

struct RtResultProperty {
  int  index;
  char *failOrPass;
  int  lengthOfBasic;
  int  lengthOfStem;
  int  lengthOfCycle;
  int  lengthOfInv;
  int  lengthOfCounterExample;
};


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/

typedef struct RtDesignList RtDesignLists_t;
typedef struct RtCommandResult RtCommandResults_t;
typedef struct RtCompareItem RtCompareItems_t;
typedef struct RtConfig RtConfigs_t;
typedef struct RtResultProperty RtResultPropertys_t;



/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/


/**AutomaticEnd***************************************************************/

#endif /* _RTINT */



































































