/**CHeaderFile*****************************************************************

  FileName    [synth.h]

  PackageName [synth]

  Synopsis    [Symbolic synthesis package.]

  Description []

  Author      [In-Ho Moon, Balakrishna Kumthekar]

  Copyright   [This file was created at the University of Colorado at
  Boulder.  The University of Colorado at Boulder makes no warranty
  about the suitability of this software for any purpose.  It is
  presented on an AS IS basis.]

  Revision    [$Id: synth.h,v 1.14 2005/05/11 20:16:47 hhhan Exp $]

******************************************************************************/

#ifndef _SYNTH
#define _SYNTH

/*---------------------------------------------------------------------------*/
/* Nested includes                                                           */
/*---------------------------------------------------------------------------*/
#include "fsm.h"
#include "part.h"
#include "st.h"
#include "util.h"
#include "bdd.h"

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/

typedef struct SynthInfoDataStruct Synth_InfoData_t;

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/

/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN void Synth_Init(void);
EXTERN void Synth_End(void);
EXTERN bdd_node * Synth_ZddQuickDivisor(bdd_manager *dd, bdd_node *f);
EXTERN bdd_node * Synth_ZddLeastDivisor(bdd_manager *dd, bdd_node *f);
EXTERN bdd_node * Synth_ZddMostDivisor(bdd_manager *dd, bdd_node *f);
EXTERN bdd_node * Synth_ZddLevelZeroDivisor(bdd_manager *dd, bdd_node *f);
EXTERN bdd_node * Synth_ZddCommonDivisor(bdd_manager *dd, bdd_node *f);
EXTERN bdd_node * Synth_ZddLpDivisor(bdd_manager *dd, bdd_node *f);
EXTERN Synth_InfoData_t * Synth_InitializeInfo(int factoring, int divisor, int unreachDC, int reordering, int trySharing, int realign, char *filehead, char *prefix, boolean eqn);
EXTERN void Synth_FreeInfo(Synth_InfoData_t *synthInfo);
EXTERN int Synth_SynthesizeNetwork(Ntk_Network_t *network, graph_t *partition, st_table *careTable, Synth_InfoData_t *synthInfo, int verbosity);
EXTERN int Synth_SynthesizeFsm(Fsm_Fsm_t *fsm, st_table *careTable, Synth_InfoData_t *synthInfo, int verbosity);

/**AutomaticEnd***************************************************************/

#endif /* _SYNTH */
