/**CFile***********************************************************************

  FileName    [tblAigEntryUtil.c]

  PackageName [tbl]

  Synopsis    []

  Description [Defines functions to manuplate table Entry using And/Inverter graph]

  SeeAlso     [tblUtil.c, tblAigUtil.c]

  Author      [Mohammad Awedh]

  Copyright   []

******************************************************************************/

#include "tblInt.h"
#include "baig.h"

static char rcsid[] UNUSED = "$Id: tblAigEntryUtil.c,v 1.4 2005/04/17 14:37:23 awedh Exp $";

/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/


/**AutomaticEnd***************************************************************/
/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Definition of internal functions                                          */
/*---------------------------------------------------------------------------*/

/**Function********************************************************************

  Synopsis    [Returns the mAigEdge_t for a table entry]

  Description [Given an array of constituent mAigEdge_t, and a table entry, this returns
  an mAig for the entry. The array of mAigEdge_t's must contain an mAigEdge_t for value i in
  position i, for all values i.]

  SideEffects []

  SeeAlso     []
[Done]
******************************************************************************/
mAigEdge_t
TblEntryNormalConstructAig(
    mAig_Manager_t *manager,
    Tbl_Entry_t    *entry,
    array_t        *mAigArray)
{
  lsGen gen;
  Tbl_Range_t *range;
  int i;
  mAigEdge_t result, temp, x;
    
  result = mAig_Zero;
  lsForEachItem(entry->EntryData.listOfRanges, gen, range) {
    for (i=range->begin; i< (range->end +1); i++) {
      temp = result;
      x = MvfAig_FunctionReadComponent(mAigArray,i);
      result = mAig_Or(manager, temp, x);
    }
  }
  return result;
}

/**Function********************************************************************

  Synopsis    [Returns the mAigEdge_t for a table entry]

  Description [Given an array of constituent mAigEdge_t, and a table entry, this returns
  an mAig for the entry. The array of mAigEdge_t's must contain an mAigEdge_t for value i in
  position i, for all values i.]

  SideEffects []

  SeeAlso     []
[Done]
******************************************************************************/
mAigEdge_t 
TblEntryEqualConstructMAig(
    mAig_Manager_t    * manager,
    Tbl_Entry_t       * entry,
    MvfAig_Function_t * mAigArray,
    MvfAig_Function_t * mEigArray)
{
  lsGen        gen;
  Tbl_Range_t *range;
  int          i;
  mAigEdge_t   result, temp, x;

  assert(entry->type == Tbl_EntryNormal_c);
  result = mAig_Zero;
  lsForEachItem(entry->EntryData.listOfRanges, gen, range) {
    for (i=range->begin; i< (range->end +1); i++) {
      temp = result;
      x = MvfAig_FunctionReadComponent(mAigArray,i);
      result = mAig_Or(manager, temp, x);
      temp = result;
      x = MvfAig_FunctionReadComponent(mAigArray,i);
      result = mAig_Or(manager, temp, x);
    }
  }
  return result;
}



