/**CHeaderFile*****************************************************************

  FileName    [truesim.h]

  PackageName [truesim]

  Synopsis    [Exported functions and data structures for the truesim package.]

  Description [Exported functions and data structures for the truesim
  package. This package provides procedures to perform pattern based
  zero delay and levelized two-pass event-driven simulation of
  circuits described in BLIF format. Pattern vectors to be simulated
  can either be provided or can be generated using user-specified
  primary input probabilities. Only combinational circuits are
  supported at this time.]

  SeeAlso     [truesimInt.h]

  Author      [Balakrishna Kumthekar]

  Copyright   [This file was created at the University of Colorado at Boulder.
  The University of Colorado at Boulder makes no warranty about the suitability
  of this software for any purpose.  It is presented on an AS IS basis.]

******************************************************************************/

#ifndef _TRUESIM
#define _TRUESIM

#include "part.h"
#include "cmd.h"
#include "util.h"

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/


/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN void Truesim_Init(void);
EXTERN void Truesim_End(void);
EXTERN int Truesim_RealDelayPatternSimulate(Ntk_Network_t *network, array_t *inputArray, array_t *patternArray);
EXTERN void Truesim_InitializeSimulation(Ntk_Network_t *network, char *delayFile, boolean truedelay, int header, int verbose, st_table *nodeDelayTable);
EXTERN void Truesim_QuitSimulation(Ntk_Network_t *network);
EXTERN void Truesim_NetworkUpdateNodeTopologicalDepth(Ntk_Network_t *network);
EXTERN void Truesim_ReadInputProbabilities(Ntk_Network_t *network, char *probFile, array_t *inputArray, array_t *probArray);
EXTERN void Truesim_GeneratePrimaryInputProbs(Ntk_Network_t *network, char *probFile);
EXTERN int Truesim_ReadSimulationVectors(Ntk_Network_t *network, char *simFile, array_t *inputArray, array_t *patternArray);
EXTERN array_t * Truesim_GenerateRandomVectors(Ntk_Network_t *network, array_t *probArray, array_t *patternArray, int numInputs, int N);
EXTERN void Truesim_DumpSimulationVectors(Ntk_Network_t *network, array_t *inputArray, array_t *patternArray, char *outFile);
EXTERN array_t * Truesim_NetworkComputeNodeDepths(Ntk_Network_t *network);
EXTERN int Truesim_NetworkReadNodeDepth(Ntk_Network_t *network, Ntk_Node_t *node);
EXTERN float Truesim_NetworkReadNodeProbability(Ntk_Network_t *network, Ntk_Node_t *node);
EXTERN float Truesim_NetworkReadNodeSwitchingProb(Ntk_Network_t *network, Ntk_Node_t *node);
EXTERN float Truesim_NetworkReadNodeLoad(Ntk_Network_t *network, Ntk_Node_t *node);
EXTERN float Truesim_NetworkReadNodeDelay(Ntk_Network_t *network, Ntk_Node_t *node);
EXTERN boolean Truesim_NetworkSetNodeLoad(Ntk_Network_t *network, Ntk_Node_t *node, float load);
EXTERN boolean Truesim_NetworkSetNodeDelay(Ntk_Network_t *network, Ntk_Node_t *node, float delay);
EXTERN boolean Truesim_NetworkSetNodeStaticProb(Ntk_Network_t *network, Ntk_Node_t *node, float prob);
EXTERN boolean Truesim_NetworkSetNodeSwitchingProb(Ntk_Network_t *network, Ntk_Node_t *node, float switching);
EXTERN float Truesim_BddNodeComputeProbability(Ntk_Network_t *network, bdd_node *func);
EXTERN int Truesim_ZeroDelayPatternSimulate(Ntk_Network_t *network, array_t *inputArray, array_t *patternArray);

/**AutomaticEnd***************************************************************/

#endif /* _TRUESIM */
