/**CHeaderFile*****************************************************************

  FileName    [vm.h]

  PackageName [vm]

  Synopsis    ["Main" package of VIS ("vm" = VIS main).]

  Author      [Originated from SIS]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. of California.
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.]

  Revision    [$Id: vm.h,v 1.5 2005/05/14 02:15:39 fabio Exp $]

******************************************************************************/

#ifndef _VM
#define _VM

/*---------------------------------------------------------------------------*/
/* Nested includes                                                           */
/*---------------------------------------------------------------------------*/
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <unistd.h>
#include "util.h"
#include "error.h"
#include "avl.h"
#include "var_set.h"
#include "array.h"
#include "st.h"
#include "list.h"
#include "graph.h"
#include "bdd.h"
#include "mdd.h"

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/

#define VIS_INFINITY	(1 << 30)

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/
extern FILE *vis_stderr;
extern FILE *vis_stdout;
extern FILE *vis_historyFile;
extern FILE *vis_stdpipe;
extern array_t *vm_commandHistoryArray;
extern char *vm_programName;


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/

/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN char * Vm_VisReadVersion(void);
EXTERN char * Vm_VisObtainLibrary(void);
EXTERN void Vm_VisInitPrintMore(void);
EXTERN int Vm_VisEndPrintMore(void);

/**AutomaticEnd***************************************************************/

#endif /* _VM */




