/**CHeaderFile*****************************************************************

  FileName    [ntkInt.h]

  PackageName [ntk]

  Synopsis    [Internal declarations for the network package.]

  Author      [Adnan Aziz, Tom Shiple]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. of California.
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.]

  Revision    [$Id: ntkInt.h,v 1.9 2002/03/05 23:24:35 awedh Exp $]

******************************************************************************/

#ifndef _NTKINT
#define _NTKINT

/*---------------------------------------------------------------------------*/
/* Nested includes                                                           */
/*---------------------------------------------------------------------------*/
#include <time.h>
#include "ntk.h"
#include "cmd.h"
#include <string.h>

extern int NtkDebug;

/*---------------------------------------------------------------------------*/
/* Structure declarations                                                    */
/*---------------------------------------------------------------------------*/

/**Enum************************************************************************

  Synopsis    [Types of network nodes.]

  Description [Types of network nodes.  See the corresponding
  Ntk_NodeTestIs<type> functions for a description of each type.]

******************************************************************************/
typedef enum {
  NtkLatch_c,         
  NtkShadow_c,         
  NtkCombinational_c,
  NtkPrimaryInput_c,
  NtkPseudoInput_c,
  NtkUnassigned_c
} NtkNodeType;


/**Struct**********************************************************************

  Synopsis    [A network of nodes.]

  Description [A network is a directed graph of nodes.  Lists are maintained
  to provide easy access to various groups of nodes.  Applications can
  associate information with a network via the application info mechanism.]

******************************************************************************/
struct NtkNetworkStruct {
  char           *name;            /* name of network */
  lsList          nodes;           /* all nodes of network */
  lsList          combInputs;      /* all primary inputs and latch outputs */
  lsList          combOutputs;     /* all primary outputs and latch inputs */
  lsList          latches;         /* all latches */
  lsList          primaryInputs;   /* all primary inputs */
  lsList          pseudoInputs;    /* all pseduo inputs */
  lsList          inputs;          /* all primary and pseudo inputs */
  lsList          primaryOutputs;  /* all primary outputs */
  st_table       *combOutputsTable;/* membership for combOutputs list */
  st_table       *mddIdToNode;     /* int to Ntk_Node_t * */
  st_table       *actualNameToNode;/* char * to Ntk_Node_t * */
  st_table       *formalNameToActualName;  /* char * to char * */
  mdd_manager    *mddManager;      /* MDD manager of network */
  bdd_reorder_type_t dynVarOrdMethod; /* method to perform dynamic variable ordering */
  st_table       *applInfoTable;   /* char * to ApplInfo_t * */
  mAig_Manager_t *mAigManager;     /* AndInv graph manager [MHA] */
  void           *undef;           /* for programmer's use; make no assumptions */
};
  

/**Struct**********************************************************************

  Synopsis    [A network node.]

  Description [A node is a vertex in the directed graph represented by a
  network.  Edges of the graph are given by the fanin and fanout arrays of a
  node.  A node has a type describing its role in the context of a
  circuit.  Also, a node has a unique name, and a unique MDD id (unless it's
  undefined).]

******************************************************************************/
struct NtkNodeStruct {
  char           *name;        /* actual name of output of node */
  Ntk_Network_t  *network;     /* network to which this node belongs */
  Var_Variable_t *variable;    /* info about the multi-valued variable of this node */
  NtkNodeType     type;        /* type of node */
  array_t        *fanins;      /* array of Ntk_Node_t * giving fanins of this node */
  array_t        *fanouts;     /* array of Ntk_Node_t * giving fanouts of this node */
  Tbl_Table_t    *table;       /* table in which the function of this node is defined */
  int             outputIndex; /* column of table which defines this node */
  int             mddId;       /* mddId of the output variable of this node */
  union {
    Ntk_Node_t   *shadow;      /* if type is not shadow, corr. shadow node (may be NULL) */
    Ntk_Node_t   *origin;      /* if type is shadow, corresponding node */
  } shadowInfo;
  boolean         outputFlag;  /* 1 if node is a primary output, else 0 */
  boolean         constant;    /* 1 if node is a constant, else 0 */
  boolean         latchDataInput; /* 1 if node is the data input to some latch, else 0 */
  boolean         latchInitialInput; /* 1 if node is the init input to some latch, else 0 */
  mAigEdge_t      mAigId;     /*Node Id of this node in the AndInv graph */
  void           *undef;       /* for programmer's use; make no assumptions */
};

/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN boolean NtkNodeDeleteFromList(lsList nodeList, Ntk_Node_t *node);

/**AutomaticEnd***************************************************************/

#endif /* _NTKINT */




