/**CHeaderFile*****************************************************************

  FileName    [ntmaig.h]

  PackageName [ntmaig]

  Synopsis    [Construction of mAigs from a flattened network.]

  Description [Provides a routine to build the mvfAigs of the roots of an
  arbitrary region of a network, in terms of the leaves of the region. The
  leaves can be treated as variables or as specific constants.]

  Author      [Mohammad Awedh]

  Copyright   []

  Revision    [$Id: ntmaig.h,v 1.3 2005/04/17 14:18:22 awedh Exp $]

******************************************************************************/

#ifndef _ntmaig
#define _ntmaig

/*---------------------------------------------------------------------------*/
/* Nested includes                                                           */
/*---------------------------------------------------------------------------*/
#include "ntk.h"
#include "baig.h"

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/
#define ntmaig_UNUSED (-1)

/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN array_t * ntmaig_NetworkBuildMvfAigs(Ntk_Network_t * network, array_t * roots, st_table * leaves);
EXTERN void ntmAig_MvfAigTableFreeCallback(void *data);
EXTERN void ntmaig_Init(void);
EXTERN void ntmaig_End(void);

/**AutomaticEnd***************************************************************/

#endif /* _ntmaig */



