/**CFile***********************************************************************

  FileName    [ tblTest.c ]

  PackageName [ tbl ]

  Synopsis    [ This package is used to manipulate the table data structure ]

  Description [ The table data structure is used to store the information
               contained in the blif_mv table. This structure supports all
               constructs in blif_mv including  the recursive constructs.
               This is consistent with the previous version of this data-
               structure.]

  SeeAlso     [ tbl.h, tblEntryUtil.c ]

  Author      [ Gitanjali M. Swamy ]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. of California.
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.]

******************************************************************************/
#include "tblInt.h"

static char rcsid[] UNUSED = "$Id: tblTest.c,v 1.12 2009/04/11 02:01:29 fabio Exp $";

/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/

static int CommandTableTest(Hrc_Manager_t ** hmgr, int argc, char ** argv);
static void TestTblPrint(Tbl_Table_t *table);

/**AutomaticEnd***************************************************************/


/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/
/**Function********************************************************************

  Synopsis    [Initializes the table (Tbl) package.]

  SideEffects []

  SeeAlso     [Ntm_End]

******************************************************************************/
void
Tbl_Init(void)
{
  Cmd_CommandAdd("_tbl_test", CommandTableTest, /* doesn't changes_network */0);
}


/**Function********************************************************************

  Synopsis    [Ends the table (Tbl) package]

  SideEffects []

  SeeAlso     [Ntm_Init]

******************************************************************************/
void
Tbl_End(void)
{
}

/**Function********************************************************************

  Synopsis    [com function for testing]

  Description [This is an internal function, whose purpose is to help
  the developer test code. It is not fixed in function.]

  SideEffects []

  CommandName [_tbl_test]
  CommandSynopsis [test the functionality of the tbl package.]
  CommandArguments [\[-h\] \[-v\]]
  CommandDescription [Tests the functionality of the tbl package.<p>
  Command options:<p>
  <dl><dt> -h
  <dd> Print the command usage.
  </dl>
  <dl><dt> -v
  <dd> Verbose mode.
  </dl>]

  SeeAlso     []

******************************************************************************/
static int
CommandTableTest(
  Hrc_Manager_t ** hmgr,
  int  argc,
  char ** argv)
{
  int c;
  Tbl_Table_t *table;
  int i;
  Hrc_Node_t * node;
  boolean verbose UNUSED = FALSE;              /* default */
  
  /*
   * Parse the command line.
   */

  util_getopt_reset();
  while ((c = util_getopt(argc, argv, "vh")) != EOF) {
    switch (c) {
      case 'v':
        verbose = 1;
        break;
      case 'h':
	goto usage;
      default:
        goto usage;
    }
  }
  
  node = Hrc_ManagerReadRootNode(*hmgr);
  if (node == NIL(Hrc_Node_t)) {
    (void) fprintf(vis_stdout, "No file has been read in. Use read_blif_mv.\n");
    return 1;
  }
    
  Hrc_NodeForEachNameTable(node,i,table) {
    if (i>0) {
      fprintf(vis_stdout, "---------------------------\n") ;
      Tbl_TableWriteBlifMvToFile (table, 0, vis_stdout) ;
        
      fprintf(vis_stdout, "---------------------------\n") ;
      
    }
    
/*    TestTblPrint(table);    */
  }
    
  return 0;
  
  usage:
  (void) fprintf(vis_stderr, "usage: _tbl_test [-h] [-v]\n");
  (void) fprintf(vis_stderr, "   -h        print the command usage\n");  
  (void) fprintf(vis_stderr, "   -v        verbose\n");
  return 1;             /* error exit */
}

/**Function********************************************************************

  Synopsis    [Test Table  code]

  Description []

  SideEffects []

  SeeAlso     []

******************************************************************************/
static void TestTblPrint(
  Tbl_Table_t *table)
{
/*  array_t *check; */
  mdd_manager    *mddMgr; 
  Tbl_Table_t *newTable;
  int             i;
/* int j, offset; */  
/*   Mvf_Function_t *outMvf; */
/*   Var_Variable_t *var; */
/*   int             colNum; */
/*   array_t        *faninMvfArray; */
/*   array_t        *mvarValues; */
/*   array_t        *totalSupportArray; */
/*   int             numInputs; */
  
/*  int rowNumi, rowNumj; */
/*  Tbl_Row_t *rowi, *rowj; */
/*   boolean check; */

  Tbl_TableWriteBlifMvToFile(table,0,vis_stdout);
  mddMgr = mdd_init_empty();
  for(i=0; i < Tbl_TableReadNumOutputs(table); i++){
    if (Tbl_TableTestIsOutputSpaceComplete(table, mddMgr) ) {
      newTable =
          Tbl_TableCreateTrueSupportTableForOutput(table,NIL(Mvf_Function_t), mddMgr,0,i,NIL(array_t));
      printf(" NEW table for %d \n", i);
      Tbl_TableWriteBlifMvToFile(newTable,0,vis_stdout);
      printf("\n");
    }
    
  }
  mdd_quit(mddMgr);

/*   Tbl_TableWriteBlifMvToFile(table,0,vis_stdout);
 *  printf(" Test 1\n");  
 *  mddMgr = mdd_init_empty();
 *  for(i=0; i < Tbl_TableReadNumOutputs(table); i++){
 *   newTable =
 *       Tbl_TableCreateTrueSupportTableForOutput(table,NIL(Mvf_Function_t), mddMgr,0,i,NIL(array_t));
 *   printf(" NEW table for %d \n", i);
 *   Tbl_TableWriteBlifMvToFile(newTable,0,vis_stdout);
 *   printf("\n");    
 * }
 *    mdd_quit(mddMgr);
 *
 *  printf(" Test 2\n");
 *
 *  mddMgr = mdd_init_empty();
 *  for(i=0; i < Tbl_TableReadNumOutputs(table); i++){
 *  mvarValues        = array_alloc(int, 0);
 *  numInputs         = Tbl_TableReadNumInputs(table );
 *  totalSupportArray = array_alloc(int, 0);
 *  faninMvfArray     = array_alloc(Mvf_Function_t *, 0);
 *
 *  Tbl_TableForEachInputVar(table, colNum, var) {
 *    array_insert_last(int, mvarValues, Var_VariableReadNumValues(var));
 *  }
 *  offset = array_n(mdd_ret_mvar_list(mddMgr));    
 *  mdd_create_variables(mddMgr,mvarValues, NIL(array_t), NIL(array_t));
 *  array_free(mvarValues);
 *
 *  for (j = 0; j < numInputs; j++) {
 *    Mvf_Function_t *faninMvf = Mvf_FunctionCreateFromVariable(mddMgr, (j+offset));
 *    array_insert_last(Mvf_Function_t *, faninMvfArray, faninMvf);
 *  }
 *
 *  outMvf = Tbl_TableBuildMvfFromFanins(table, i, faninMvfArray, mddMgr);
 *  Mvf_FunctionArrayFree(faninMvfArray);
 *   newTable =
 *       Tbl_TableCreateTrueSupportTableForOutput(table,outMvf, mddMgr,offset,i,NIL(array_t));  
 *   printf(" NEW table for %d \n", i);
 *   Tbl_TableWriteBlifMvToFile(newTable,0,vis_stdout);
 *   printf("\n");    
 * }
 *    mdd_quit(mddMgr);
 */  
  /* testing hard and soft dups */
   
/*   newTable = Tbl_TableHardDup(table);
 *  printf(" NEW table Hard\n");
 *  Tbl_TableWriteBlifMvToFile(newTable,0,vis_stdout);
 *  Tbl_TableSetEntryDc(newTable,Tbl_TableReadNumRows(table)-1,\
 *                      Tbl_TableReadNumInputs(table)-1, 0);
 *  printf(" NEW table Hard Modify\n");
 *  Tbl_TableWriteBlifMvToFile(newTable,0,vis_stdout);
 *  printf(" Old  table Hard Modify \n" );
 *  Tbl_TableWriteBlifMvToFile(table,0,vis_stdout);
 *  Tbl_TableFree(newTable); 
 * 
 *  newTable = Tbl_TableSoftDup(table);
 *  printf(" NEW table Soft\n");
 *  Tbl_TableWriteBlifMvToFile(table,0,vis_stdout);  
 *  printf(" NEW table Soft\n");
 *  Tbl_TableWriteBlifMvToFile(newTable,0,vis_stdout);
 *  Tbl_TableSetEntryDc(newTable,Tbl_TableReadNumRows(table)-1,\
 *                      Tbl_TableReadNumInputs(table)-1, 0);
 *  printf(" NEW table Soft Modify\n");
 *  Tbl_TableWriteBlifMvToFile(newTable,0,vis_stdout);
 *  printf(" Old  table Soft Modify \n" );
 *  Tbl_TableWriteBlifMvToFile(table,0,vis_stdout);
 *  Tbl_TableFree(newTable);
 *   Tbl_TableFree(table);
 */

  /* testing row intersect */
  
/*   TblTableForEachRow(table,rowi,rowNumi) {
 *     TblTableForEachRow(table,rowj,rowNumj) {
 *       check = Tbl_RowInputIntersect(table,rowNumi, rowNumj);
 *       printf("Rows %d and %d intersect = %d\n",rowNumi, rowNumj, check);
 *     }
 * }
 */
}













