/**CHeaderFile*****************************************************************

  FileName    [var.h]

  PackageName [var]

  Synopsis    [Multi-valued variables.]

  Description [This package contains the data structure for multi-valued
  variables. For each variable in a BLIF-MV network, this structure is
  created. The information contained in this structure for a variable is
  the name, the type (PI,PO,PS,NS etc), the range size, the list of symbolic
  value names if any, and the encoding of a variable. Any variable can be
  categorized either to an enumerative variable or a symbolic variable. 
  Enumerative variables are variables which take values from [0,...,n-1\],
  where n is the range of the variable, while symbolic variables are
  variables which take symbolic values (e.g., [red,blue,green\]). ]

  SeeAlso     []

  Author      [Yuji Kukimoto]

  Copyright   [Copyright (c) 1994-1996 The Regents of the Univ. of California.
  All rights reserved.

  Permission is hereby granted, without written agreement and without license
  or royalty fees, to use, copy, modify, and distribute this software and its
  documentation for any purpose, provided that the above copyright notice and
  the following two paragraphs appear in all copies of this software.

  IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
  OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
  CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN
  "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE
  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.]

  Revision    [$Id: var.h,v 1.3 1998/05/19 22:04:27 hsv Exp $]

******************************************************************************/

#ifndef _VAR
#define _VAR

/*---------------------------------------------------------------------------*/
/* Nested includes                                                           */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Stucture declarations                                                     */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/
typedef struct VarVariableStruct Var_Variable_t;

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/

#include "hrc.h"

/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

EXTERN boolean Var_VariableAddRangeInfo(Var_Variable_t * var, int numValues, array_t * symValArray);
EXTERN boolean Var_VariableExpandRange(Var_Variable_t *var, int numValues);
EXTERN boolean Var_VariableReduceRange(Var_Variable_t *var, int numValues);
EXTERN Var_Variable_t * Var_VariableAlloc(Hrc_Node_t *hnode, char *name);
EXTERN void Var_VariableFree(Var_Variable_t *var);
EXTERN Var_Variable_t * Var_VariableDup(Var_Variable_t *var, Hrc_Node_t *hnode);
EXTERN char * Var_VariableReadName(Var_Variable_t *var);
EXTERN boolean Var_VariableTestIsPI(Var_Variable_t *var);
EXTERN boolean Var_VariableTestIsPO(Var_Variable_t *var);
EXTERN boolean Var_VariableTestIsPS(Var_Variable_t *var);
EXTERN boolean Var_VariableTestIsNS(Var_Variable_t *var);
EXTERN boolean Var_VariableTestIsSI(Var_Variable_t *var);
EXTERN boolean Var_VariableTestIsSO(Var_Variable_t *var);
EXTERN boolean Var_VariableTestIsSymbolic(Var_Variable_t *var);
EXTERN boolean Var_VariableTestIsEnumerative(Var_Variable_t *var);
EXTERN boolean Var_VariableTestIsValueInRange(Var_Variable_t *var, int value);
EXTERN int Var_VariableReadNumValues(Var_Variable_t *var);
EXTERN int Var_VariableReadNumFanoutTables(Var_Variable_t *var);
EXTERN void Var_VariableIncrementNumFanoutTables(Var_Variable_t *var);
EXTERN void Var_VariableResetNumFanoutTables(Var_Variable_t* var);
EXTERN char * Var_VariableReadSymbolicValueFromIndex(Var_Variable_t *var, int i);
EXTERN int Var_VariableReadIndexFromSymbolicValue(Var_Variable_t *var, char *symbolicValue);
EXTERN Hrc_Node_t * Var_VariableReadHnode(Var_Variable_t *var);
EXTERN char * Var_VariableReadTypeIdentifier(Var_Variable_t *var);
EXTERN void * Var_VariableReadUndef(Var_Variable_t *var);
EXTERN boolean Var_VariableChangeName(Var_Variable_t *var, char *name);
EXTERN int Var_VariableSetPI(Var_Variable_t *var);
EXTERN int Var_VariableSetPO(Var_Variable_t *var);
EXTERN int Var_VariableSetPS(Var_Variable_t *var);
EXTERN int Var_VariableSetNS(Var_Variable_t *var);
EXTERN int Var_VariableSetSI(Var_Variable_t *var);
EXTERN int Var_VariableSetSO(Var_Variable_t *var);
EXTERN int Var_VariableResetPI(Var_Variable_t *var);
EXTERN int Var_VariableResetPO(Var_Variable_t *var);
EXTERN int Var_VariableResetPS(Var_Variable_t *var);
EXTERN int Var_VariableResetNS(Var_Variable_t *var);
EXTERN int Var_VariableResetSI(Var_Variable_t *var);
EXTERN int Var_VariableResetSO(Var_Variable_t *var);
EXTERN void Var_VariableResetAllTypes(Var_Variable_t *var);
EXTERN void Var_VariableSetTypeIdentifier(Var_Variable_t *var, char *typeIdentifier);
EXTERN boolean Var_VariablesTestIdentical(Var_Variable_t *var1, Var_Variable_t *var2);
EXTERN boolean Var_VariablesTestHaveSameDomain(Var_Variable_t *var1, Var_Variable_t *var2);
EXTERN boolean Var_VariableTestTypeConsistency(Var_Variable_t *var);
EXTERN boolean Var_VariablesTestHaveSameTypeIdentifier(Var_Variable_t *var1, Var_Variable_t *var2);

/**AutomaticEnd***************************************************************/

#endif /* _VAR */


















